/*
 * Decompiled with CFR 0.152.
 */
package de.guntram.mcmod.randomblockplacement;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.guntram.mcmod.crowdintranslate.CrowdinTranslate;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_1661;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_746;

public class RandomBlockPlacement
implements ClientModInitializer {
    static final String MODID = "randomblockplacement";
    static final String MODNAME = "RandomBlockPlacement";
    private static RandomBlockPlacement instance;
    private boolean isActive;
    private int minSlot;
    private int maxSlot;
    private class_304 onOff;

    public void onInitializeClient() {
        CrowdinTranslate.downloadTranslations((String)MODID);
        instance = this;
        this.setKeyBindings();
        this.registerCommands();
        this.isActive = false;
        this.minSlot = 0;
        this.maxSlot = class_1661.method_7368() - 1;
    }

    private void setKeyBindings() {
        String category = "key.categories.randomblockplacement";
        this.onOff = new class_304("key.randomblockplacement.toggle", class_3675.class_307.field_1668, 82, "key.categories.randomblockplacement");
        KeyBindingHelper.registerKeyBinding((class_304)this.onOff);
        ClientTickEvents.END_CLIENT_TICK.register(e -> this.processKeyBinds());
    }

    private void processKeyBinds() {
        if (this.onOff.method_1436()) {
            if (this.isActive) {
                instance.setInactive();
            } else {
                instance.setActive();
            }
        }
    }

    public static RandomBlockPlacement getInstance() {
        return instance;
    }

    public void setInactive() {
        class_746 player = class_310.method_1551().field_1724;
        if (player != null) {
            player.method_7353((class_2561)class_2561.method_43471((String)"msg.inactive"), false);
        }
        this.isActive = false;
    }

    public void setActive(int first, int last) {
        this.minSlot = first - 1;
        this.maxSlot = last - 1;
        if (this.maxSlot >= class_1661.method_7368()) {
            this.maxSlot = class_1661.method_7368() - 1;
        }
        this.setActive();
    }

    public void setActive() {
        class_746 player = class_310.method_1551().field_1724;
        if (player != null) {
            player.method_7353((class_2561)class_2561.method_43469((String)"msg.active", (Object[])new Object[]{this.minSlot + 1, this.maxSlot + 1}), false);
        }
        this.isActive = true;
    }

    public void onPlayerInteract() {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        class_1661 inventory = player.method_31548();
        int index = inventory.field_7545;
        if (this.maxSlot >= class_1661.method_7368()) {
            this.maxSlot = class_1661.method_7368() - 1;
        }
        if (this.isActive && index >= this.minSlot && index <= this.maxSlot && (inventory.method_5438(index).method_7909() == class_1802.field_8162 || inventory.method_5438(index).method_7909() instanceof class_1747)) {
            int targetSlot;
            int totalBlocks = 0;
            for (int i = this.minSlot; i <= this.maxSlot; ++i) {
                totalBlocks += this.getBlockCount(inventory, i);
            }
            int targetCount = (int)(Math.random() * (double)totalBlocks);
            for (targetSlot = this.minSlot; targetSlot < this.maxSlot && targetCount >= this.getBlockCount(inventory, targetSlot); targetCount -= this.getBlockCount(inventory, targetSlot), ++targetSlot) {
            }
            inventory.field_7545 = targetSlot;
        }
    }

    private int getBlockCount(class_1661 inventory, int targetSlot) {
        class_1799 stack = inventory.method_5438(targetSlot);
        class_1792 item = stack.method_7909();
        if (item instanceof class_1747) {
            return stack.method_7947();
        }
        return 0;
    }

    public void registerCommands() {
        int size = class_1661.method_7368();
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"rblock").then(ClientCommandManager.literal((String)"off").executes(c -> {
            instance.setInactive();
            return 1;
        }))).then(ClientCommandManager.argument((String)"b1", (ArgumentType)IntegerArgumentType.integer((int)1, (int)size)).then(ClientCommandManager.argument((String)"b2", (ArgumentType)IntegerArgumentType.integer((int)1, (int)size)).executes(c -> {
            instance.setActive(IntegerArgumentType.getInteger((CommandContext)c, (String)"b1"), IntegerArgumentType.getInteger((CommandContext)c, (String)"b2"));
            return 1;
        })))));
    }
}

