/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.internal.common.cache.texture;

import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import mod.azure.azurelib.common.internal.common.cache.texture.AnimatableTexture;
import mod.azure.azurelib.common.internal.common.cache.texture.AzAbstractTexture;
import mod.azure.azurelib.common.internal.common.cache.texture.util.AnimationContents;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1079;
import net.minecraft.class_1084;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3270;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_4573;
import org.jetbrains.annotations.Nullable;

public class CombinedGlowingAnimatableTexture
extends AzAbstractTexture {
    private AnimationContents animationContents = null;
    private boolean isAnimated = false;
    private static final String GLOW_LAYER_SUFFIX = "_glowmask";
    private final class_2960 glowLayer;

    public CombinedGlowingAnimatableTexture(class_2960 baseLocation) {
        super(baseLocation);
        this.glowLayer = CombinedGlowingAnimatableTexture.appendToPath(baseLocation, GLOW_LAYER_SUFFIX);
    }

    @Override
    public void method_4625(class_3300 manager) throws IOException {
        class_1011 baseImage;
        class_3298 originalResource = manager.getResourceOrThrow(this.field_5224);
        try (InputStream inputStream = originalResource.method_14482();){
            baseImage = class_1011.method_4309((InputStream)inputStream);
        }
        this.animationContents = originalResource.method_14481().method_43041((class_3270)class_1079.field_5337).map(metadata -> new AnimationContents(baseImage, (class_1079)metadata, this.method_4624(), this.field_5224)).orElse(null);
        if (this.animationContents != null && this.animationContents.isValid()) {
            this.isAnimated = true;
        }
        class_1011 glowImage = this.processGlowLayer(manager, baseImage);
        this.uploadTextures(baseImage, glowImage);
    }

    @Override
    @Nullable
    protected class_4573 loadTexture(class_3300 resourceManager, class_310 mc) throws IOException {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private class_1011 processGlowLayer(class_3300 manager, class_1011 baseImage) {
        try {
            Optional glowLayerResource = manager.method_14486(this.glowLayer);
            if (!glowLayerResource.isPresent()) {
                Optional metadataSection = manager.getResourceOrThrow(this.field_5224).method_14481().method_43041((class_3270)class_1084.field_5344);
                if (!metadataSection.isPresent()) return null;
                return new class_1011(baseImage.method_4307(), baseImage.method_4323(), true);
            }
            try (InputStream inputStream = ((class_3298)glowLayerResource.get()).method_14482();){
                class_1011 class_10112 = class_1011.method_4309((InputStream)inputStream);
                return class_10112;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private void uploadTextures(class_1011 baseImage, class_1011 glowImage) {
        if (this.animationContents != null) {
            TextureUtil.prepareImage((int)this.method_4624(), (int)0, (int)this.animationContents.frameSize.comp_1049(), (int)this.animationContents.frameSize.comp_1050());
            baseImage.method_4312(0, 0, 0, 0, 0, this.animationContents.frameSize.comp_1049(), this.animationContents.frameSize.comp_1050(), false, false);
        } else {
            TextureUtil.prepareImage((int)this.method_4624(), (int)0, (int)baseImage.method_4307(), (int)baseImage.method_4323());
            baseImage.method_4312(0, 0, 0, 0, 0, baseImage.method_4307(), baseImage.method_4323(), false, false);
        }
        if (glowImage != null) {
            int glowTextureId = class_310.method_1551().method_1531().method_34590(this.glowLayer, (class_1044)new class_1043(glowImage)).method_4624();
            TextureUtil.prepareImage((int)glowTextureId, (int)0, (int)glowImage.method_4307(), (int)glowImage.method_4323());
            glowImage.method_4312(0, 0, 0, 0, 0, glowImage.method_4307(), glowImage.method_4323(), false, false);
        }
    }

    public static void setAndUpdate(class_2960 texturePath, int frameTick) {
        class_1044 texture = class_310.method_1551().method_1531().method_4619(texturePath);
        if (texture instanceof AnimatableTexture) {
            AnimatableTexture animatableTexture = (AnimatableTexture)texture;
            animatableTexture.setAnimationFrame(frameTick);
        }
        RenderSystem.setShaderTexture((int)0, (int)texture.method_4624());
    }

    public boolean isAnimated() {
        return this.isAnimated;
    }
}

