/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.animation.dispatch.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import mod.azure.azurelib.common.internal.common.AzureLib;
import mod.azure.azurelib.common.internal.common.network.packet.AzBlockEntityDispatchCommandPacket;
import mod.azure.azurelib.common.internal.common.network.packet.AzEntityDispatchCommandPacket;
import mod.azure.azurelib.common.internal.common.network.packet.AzItemStackDispatchCommandPacket;
import mod.azure.azurelib.common.platform.Services;
import mod.azure.azurelib.rewrite.animation.AzAnimator;
import mod.azure.azurelib.rewrite.animation.AzAnimatorAccessor;
import mod.azure.azurelib.rewrite.animation.dispatch.AzDispatchSide;
import mod.azure.azurelib.rewrite.animation.dispatch.command.AzRootCommandBuilder;
import mod.azure.azurelib.rewrite.animation.dispatch.command.action.AzAction;
import mod.azure.azurelib.rewrite.animation.play_behavior.AzPlayBehavior;
import mod.azure.azurelib.rewrite.animation.play_behavior.AzPlayBehaviors;
import mod.azure.azurelib.rewrite.util.codec.AzListStreamCodec;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import net.minecraft.class_9139;

public record AzCommand(List<AzAction> actions) {
    public static final class_9139<class_2540, AzCommand> CODEC = class_9139.method_56434(new AzListStreamCodec<AzAction>(AzAction.CODEC), AzCommand::actions, AzCommand::new);

    public static AzRootCommandBuilder builder() {
        return new AzRootCommandBuilder();
    }

    public static AzCommand compose(Collection<AzCommand> commands) {
        if (commands.isEmpty()) {
            throw new IllegalArgumentException("Attempted to compose an empty collection of commands.");
        }
        if (commands.size() == 1) {
            return commands.iterator().next();
        }
        return new AzCommand(commands.stream().flatMap(command -> command.actions().stream()).toList());
    }

    public static AzCommand compose(AzCommand first, AzCommand second, AzCommand ... others) {
        ArrayList<AzCommand> allCommands = new ArrayList<AzCommand>();
        allCommands.add(first);
        allCommands.add(second);
        Collections.addAll(allCommands, others);
        return AzCommand.compose(allCommands);
    }

    public static AzCommand create(String controllerName, String animationName) {
        return AzCommand.create(controllerName, animationName, AzPlayBehaviors.PLAY_ONCE);
    }

    public static AzCommand create(String controllerName, String animationName, AzPlayBehavior playBehavior) {
        return AzCommand.builder().playSequence(controllerName, sequenceBuilder -> sequenceBuilder.queue(animationName, props -> props.withPlayBehavior(playBehavior))).build();
    }

    public void sendForEntity(class_1297 entity) {
        if (entity.method_37908().method_8608()) {
            this.dispatchFromClient(entity);
        } else {
            int entityId = entity.method_5628();
            AzEntityDispatchCommandPacket packet = new AzEntityDispatchCommandPacket(entityId, this);
            Services.NETWORK.sendToTrackingEntityAndSelf(packet, entity);
        }
    }

    public void sendForBlockEntity(class_2586 entity) {
        if (entity.method_10997().method_8608()) {
            this.dispatchFromClient(entity);
        } else {
            class_2338 entityBlockPos = entity.method_11016();
            AzBlockEntityDispatchCommandPacket packet = new AzBlockEntityDispatchCommandPacket(entityBlockPos, this);
            Services.NETWORK.sendToEntitiesTrackingChunk(packet, (class_3218)entity.method_10997(), entityBlockPos);
        }
    }

    public void sendForItem(class_1297 entity, class_1799 itemStack) {
        if (entity.method_37908().method_8608()) {
            this.dispatchFromClient(entity);
        } else {
            UUID uuid = (UUID)itemStack.method_57824(AzureLib.AZ_ID.get());
            if (uuid == null) {
                AzureLib.LOGGER.warn("Could not find item stack UUID during dispatch. Did you forget to register an identity for the item? Item: {}, Item Stack: {}", (Object)itemStack.method_7909(), (Object)itemStack);
                return;
            }
            AzItemStackDispatchCommandPacket packet = new AzItemStackDispatchCommandPacket(uuid, this);
            Services.NETWORK.sendToTrackingEntityAndSelf(packet, entity);
        }
    }

    private <T> void dispatchFromClient(T animatable) {
        AzAnimator animator = AzAnimatorAccessor.getOrNull(animatable);
        if (animator != null) {
            this.actions.forEach(action -> action.handle(AzDispatchSide.CLIENT, animator));
        }
    }
}

