/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.animation.property.codec;

import mod.azure.azurelib.rewrite.animation.easing.AzEasingType;
import mod.azure.azurelib.rewrite.animation.easing.AzEasingTypeRegistry;
import mod.azure.azurelib.rewrite.animation.easing.AzEasingTypes;
import mod.azure.azurelib.rewrite.animation.property.AzAnimationProperties;
import net.minecraft.class_2540;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

public class AzAnimationPropertiesCodec
implements class_9139<class_2540, AzAnimationProperties> {
    @NotNull
    public AzAnimationProperties decode(class_2540 buf) {
        int propertyLength = buf.readByte();
        AzAnimationProperties properties = AzAnimationProperties.EMPTY;
        block5: for (int i = 0; i < propertyLength; ++i) {
            byte code = buf.readByte();
            switch (code) {
                case 0: {
                    properties = properties.withAnimationSpeed(buf.readDouble());
                    continue block5;
                }
                case 1: {
                    properties = properties.withTransitionLength(buf.readFloat());
                    continue block5;
                }
                case 2: {
                    AzEasingType easingType = AzEasingTypeRegistry.getOrDefault(buf.method_19772(), AzEasingTypes.NONE);
                    properties = properties.withEasingType(easingType);
                }
            }
        }
        return properties;
    }

    public void encode(class_2540 buf, AzAnimationProperties properties) {
        int propertyLength = 0;
        propertyLength += properties.hasAnimationSpeed() ? 1 : 0;
        propertyLength += properties.hasTransitionLength() ? 1 : 0;
        buf.method_52997(propertyLength += properties.hasEasingType() ? 1 : 0);
        if (properties.hasAnimationSpeed()) {
            buf.method_52997(0);
            buf.method_52940(properties.animationSpeed());
        }
        if (properties.hasTransitionLength()) {
            buf.method_52997(1);
            buf.method_52941(properties.transitionLength());
        }
        if (properties.hasEasingType()) {
            buf.method_52997(2);
            buf.method_10814(properties.easingType().name());
        }
    }
}

