/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.render.item;

import mod.azure.azurelib.common.internal.client.util.RenderUtils;
import mod.azure.azurelib.common.internal.common.cache.texture.AnimatableTexture;
import mod.azure.azurelib.rewrite.render.AzLayerRenderer;
import mod.azure.azurelib.rewrite.render.AzRendererConfig;
import mod.azure.azurelib.rewrite.render.AzRendererPipeline;
import mod.azure.azurelib.rewrite.render.AzRendererPipelineContext;
import mod.azure.azurelib.rewrite.render.item.AzItemModelRenderer;
import mod.azure.azurelib.rewrite.render.item.AzItemRenderer;
import mod.azure.azurelib.rewrite.render.item.AzItemRendererConfig;
import mod.azure.azurelib.rewrite.render.item.AzItemRendererPipelineContext;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_4587;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class AzItemRendererPipeline
extends AzRendererPipeline<class_1799> {
    private final AzItemRenderer itemRenderer;
    protected Matrix4f itemRenderTranslations = new Matrix4f();
    protected Matrix4f modelRenderTranslations = new Matrix4f();

    public AzItemRendererPipeline(AzItemRendererConfig config, AzItemRenderer itemRenderer) {
        super(config);
        this.itemRenderer = itemRenderer;
    }

    @Override
    protected AzRendererPipelineContext<class_1799> createContext(AzRendererPipeline<class_1799> rendererPipeline) {
        return new AzItemRendererPipelineContext(rendererPipeline);
    }

    protected AzItemModelRenderer createModelRenderer(AzLayerRenderer<class_1799> layerRenderer) {
        return new AzItemModelRenderer(this, layerRenderer);
    }

    @Override
    protected AzLayerRenderer<class_1799> createLayerRenderer(AzRendererConfig<class_1799> config) {
        return new AzLayerRenderer<class_1799>(config::renderLayers);
    }

    @Override
    public void preRender(AzRendererPipelineContext<class_1799> context, boolean isReRender) {
        class_4587 poseStack = context.poseStack();
        this.itemRenderTranslations = new Matrix4f((Matrix4fc)poseStack.method_23760().method_23761());
        AzItemRendererConfig config = this.itemRenderer.config();
        float scaleWidth = config.scaleWidth();
        float scaleHeight = config.scaleHeight();
        this.scaleModelForRender(context, scaleWidth, scaleHeight, isReRender);
        if (!isReRender) {
            boolean useNewOffset = config.useNewOffset();
            poseStack.method_46416(0.5f, useNewOffset ? 0.0f : 0.51f, 0.5f);
        }
        config.preRenderEntry(context);
    }

    @Override
    public void postRender(AzRendererPipelineContext<class_1799> context, boolean isReRender) {
        this.config.postRenderEntry(context);
    }

    @Override
    public void updateAnimatedTextureFrame(class_1799 animatable) {
        AnimatableTexture.setAndUpdate(this.config.textureLocation(animatable), class_1792.method_7880((class_1792)animatable.method_7909()) + (int)RenderUtils.getCurrentTick());
    }

    public AzItemRenderer getRenderer() {
        return this.itemRenderer;
    }
}

