/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.sblforked.api.core.behaviour.custom.move;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import mod.azure.azurelib.sblforked.api.core.behaviour.ExtendedBehaviour;
import mod.azure.azurelib.sblforked.util.BrainUtils;
import net.minecraft.class_11;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_5532;
import net.minecraft.class_6670;

public class AvoidEntity<E extends class_1314>
extends ExtendedBehaviour<E> {
    private static final List<Pair<class_4140<?>, class_4141>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)class_4140.field_18442, (Object)class_4141.field_18456)});
    protected Predicate<class_1309> avoidingPredicate = target -> false;
    protected float noCloserThanSqr = 9.0f;
    protected float stopAvoidingAfterSqr = 49.0f;
    protected float speedModifier = 1.0f;
    private class_11 runPath = null;

    public AvoidEntity() {
        this.noTimeout();
    }

    @Override
    protected List<Pair<class_4140<?>, class_4141>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    public AvoidEntity<E> noCloserThan(float blocks) {
        this.noCloserThanSqr = blocks * blocks;
        return this;
    }

    public AvoidEntity<E> stopCaringAfter(float blocks) {
        this.stopAvoidingAfterSqr = blocks * blocks;
        return this;
    }

    public AvoidEntity<E> avoiding(Predicate<class_1309> predicate) {
        this.avoidingPredicate = predicate;
        return this;
    }

    public AvoidEntity<E> speedModifier(float mod) {
        this.speedModifier = mod;
        return this;
    }

    protected boolean checkExtraStartConditions(class_3218 level, E entity) {
        Optional target = ((class_6670)BrainUtils.getMemory(entity, class_4140.field_18442)).method_38975(this.avoidingPredicate);
        if (target.isEmpty()) {
            return false;
        }
        class_1309 avoidingEntity = (class_1309)target.get();
        double distToTarget = avoidingEntity.method_5858(entity);
        if (distToTarget > (double)this.noCloserThanSqr) {
            return false;
        }
        class_243 runPos = class_5532.method_31511(entity, (int)16, (int)7, (class_243)avoidingEntity.method_19538());
        if (runPos == null || avoidingEntity.method_5649(runPos.field_1352, runPos.field_1351, runPos.field_1350) < distToTarget) {
            return false;
        }
        this.runPath = entity.method_5942().method_6352(runPos.field_1352, runPos.field_1351, runPos.field_1350, 0);
        return this.runPath != null;
    }

    @Override
    protected boolean shouldKeepRunning(E entity) {
        return !this.runPath.method_46();
    }

    @Override
    protected void start(E entity) {
        entity.method_5942().method_6334(this.runPath, (double)this.speedModifier);
    }

    @Override
    protected void stop(E entity) {
        this.runPath = null;
        entity.method_5942().method_6344(1.0);
    }
}

