/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.internal.common.cache.texture.util;

import com.mojang.blaze3d.platform.TextureUtil;
import mod.azure.azurelib.common.internal.common.cache.texture.AzAbstractTexture;
import mod.azure.azurelib.common.internal.common.cache.texture.util.Frame;
import net.minecraft.class_1011;
import net.minecraft.class_7771;

public class Texture
implements AutoCloseable {
    private final class_1011 baseImage;
    private final Frame[] frames;
    private final int framePanelSize;
    private final boolean interpolating;
    private final class_1011 interpolatedFrame;
    private final int totalFrameTime;
    private int currentFrame;
    private int currentSubframe;
    private final class_7771 frameSize;
    private int getID;

    public Texture(class_1011 baseImage, Frame[] frames, int framePanelSize, boolean interpolating, class_7771 frameSize, int getID) {
        this.baseImage = baseImage;
        this.frames = frames;
        this.framePanelSize = framePanelSize;
        this.interpolating = interpolating;
        this.interpolatedFrame = interpolating ? new class_1011(frameSize.comp_1049(), frameSize.comp_1050(), false) : null;
        int time = 0;
        for (Frame frame : this.frames) {
            time += frame.time();
        }
        this.totalFrameTime = time;
        this.frameSize = frameSize;
        this.getID = getID;
    }

    private int getFrameX(int frameIndex) {
        return frameIndex % this.framePanelSize;
    }

    private int getFrameY(int frameIndex) {
        return frameIndex / this.framePanelSize;
    }

    public void setCurrentFrame(int ticks) {
        if ((ticks %= this.totalFrameTime) == this.currentSubframe) {
            return;
        }
        int lastSubframe = this.currentSubframe;
        int lastFrame = this.currentFrame;
        int time = 0;
        for (Frame frame : this.frames) {
            if (ticks >= (time += frame.time())) continue;
            this.currentFrame = frame.index();
            this.currentSubframe = ticks % frame.time();
            break;
        }
        if (this.currentFrame != lastFrame && this.currentSubframe == 0) {
            AzAbstractTexture.onRenderThread(() -> {
                TextureUtil.prepareImage((int)this.getID, (int)0, (int)this.frameSize.comp_1049(), (int)this.frameSize.comp_1050());
                this.baseImage.method_4312(0, 0, 0, this.getFrameX(this.currentFrame) * this.frameSize.comp_1049(), this.getFrameY(this.currentFrame) * this.frameSize.comp_1050(), this.frameSize.comp_1049(), this.frameSize.comp_1050(), false, false);
            });
        } else if (this.currentSubframe != lastSubframe && this.interpolating) {
            AzAbstractTexture.onRenderThread(this::generateInterpolatedFrame);
        }
    }

    private void generateInterpolatedFrame() {
        Frame frame = this.frames[this.currentFrame];
        double frameProgress = 1.0 - (double)this.currentSubframe / (double)frame.time();
        int nextFrameIndex = this.frames[(this.currentFrame + 1) % this.frames.length].index();
        if (frame.index() != nextFrameIndex) {
            for (int y = 0; y < this.interpolatedFrame.method_4323(); ++y) {
                for (int x = 0; x < this.interpolatedFrame.method_4307(); ++x) {
                    int prevFramePixel = this.getPixel(frame.index(), x, y);
                    int nextFramePixel = this.getPixel(nextFrameIndex, x, y);
                    int blendedRed = this.interpolate(frameProgress, prevFramePixel >> 16 & 0xFF, nextFramePixel >> 16 & 0xFF);
                    int blendedGreen = this.interpolate(frameProgress, prevFramePixel >> 8 & 0xFF, nextFramePixel >> 8 & 0xFF);
                    int blendedBlue = this.interpolate(frameProgress, prevFramePixel & 0xFF, nextFramePixel & 0xFF);
                    this.interpolatedFrame.method_4305(x, y, prevFramePixel & 0xFF000000 | blendedRed << 16 | blendedGreen << 8 | blendedBlue);
                }
            }
            TextureUtil.prepareImage((int)this.getID, (int)0, (int)this.frameSize.comp_1049(), (int)this.frameSize.comp_1050());
            this.interpolatedFrame.method_4312(0, 0, 0, 0, 0, this.frameSize.comp_1049(), this.frameSize.comp_1050(), false, false);
        }
    }

    private int getPixel(int frameIndex, int x, int y) {
        return this.baseImage.method_4315(x + this.getFrameX(frameIndex) * this.frameSize.comp_1049(), y + this.getFrameY(frameIndex) * this.frameSize.comp_1050());
    }

    private int interpolate(double frameProgress, double prevColour, double nextColour) {
        return (int)(frameProgress * prevColour + (1.0 - frameProgress) * nextColour);
    }

    @Override
    public void close() {
        this.baseImage.close();
        if (this.interpolatedFrame != null) {
            this.interpolatedFrame.close();
        }
    }
}

