/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.animation.easing;

import it.unimi.dsi.fastutil.doubles.Double2DoubleFunction;
import mod.azure.azurelib.rewrite.animation.controller.keyframe.AzAnimationPoint;
import mod.azure.azurelib.rewrite.animation.easing.AzEasingType;
import mod.azure.azurelib.rewrite.animation.easing.AzEasingTypes;

public class AzEasingUtil {
    public static Double2DoubleFunction linear(Double2DoubleFunction function) {
        return function;
    }

    public static double catmullRom(double n) {
        return 0.5 * (2.0 * (n + 1.0) + (n + 2.0 - n) * 1.0 + (2.0 * n - 5.0 * (n + 1.0) + 4.0 * (n + 2.0) - (n + 3.0)) * 1.0 + (3.0 * (n + 1.0) - n - 3.0 * (n + 2.0) + (n + 3.0)) * 1.0);
    }

    public static Double2DoubleFunction easeIn(Double2DoubleFunction function) {
        return function;
    }

    public static Double2DoubleFunction easeOut(Double2DoubleFunction function) {
        return time -> 1.0 - (Double)function.apply((Object)(1.0 - time));
    }

    public static Double2DoubleFunction easeInOut(Double2DoubleFunction function) {
        return time -> {
            if (time < 0.5) {
                return (Double)function.apply((Object)(time * 2.0)) / 2.0;
            }
            return 1.0 - (Double)function.apply((Object)((1.0 - time) * 2.0)) / 2.0;
        };
    }

    public static Double2DoubleFunction stepPositive(Double2DoubleFunction function) {
        return n -> n > 0.0 ? 1.0 : 0.0;
    }

    public static Double2DoubleFunction stepNonNegative(Double2DoubleFunction function) {
        return n -> n >= 0.0 ? 1.0 : 0.0;
    }

    public static double linear(double n) {
        return n;
    }

    public static double quadratic(double n) {
        return n * n;
    }

    public static double cubic(double n) {
        return n * n * n;
    }

    public static double sine(double n) {
        return 1.0 - Math.cos(n * Math.PI / 2.0);
    }

    public static double circle(double n) {
        return 1.0 - Math.sqrt(1.0 - n * n);
    }

    public static double exp(double n) {
        return Math.pow(2.0, 10.0 * (n - 1.0));
    }

    public static Double2DoubleFunction elastic(Double n) {
        double n2 = n == null ? 1.0 : n;
        return t -> 1.0 - Math.pow(Math.cos(t * Math.PI / 2.0), 3.0) * Math.cos(t * n2 * Math.PI);
    }

    public static Double2DoubleFunction bounce(Double n) {
        double n2 = n == null ? 0.5 : n;
        Double2DoubleFunction one = x -> 7.5625 * x * x;
        Double2DoubleFunction two = x -> 30.25 * n2 * Math.pow(x - 0.5454545617103577, 2.0) + 1.0 - n2;
        Double2DoubleFunction three = x -> 121.0 * n2 * n2 * Math.pow(x - 0.8181818127632141, 2.0) + 1.0 - n2 * n2;
        Double2DoubleFunction four = x -> 484.0 * n2 * n2 * n2 * Math.pow(x - 0.9545454382896423, 2.0) + 1.0 - n2 * n2 * n2;
        return t -> Math.min(Math.min((Double)one.apply((Object)t), (Double)two.apply((Object)t)), Math.min((Double)three.apply((Object)t), (Double)four.apply((Object)t)));
    }

    public static Double2DoubleFunction back(Double n) {
        double n2 = n == null ? 1.70158 : n * 1.70158;
        return t -> t * t * ((n2 + 1.0) * t - n2);
    }

    public static Double2DoubleFunction pow(double n) {
        return t -> Math.pow(t, n);
    }

    public static Double2DoubleFunction step(Double n) {
        double n2;
        double d = n2 = n == null ? 2.0 : n;
        if (n2 < 2.0) {
            throw new IllegalArgumentException("Steps must be >= 2, got: " + n2);
        }
        int steps = (int)n2;
        return t -> {
            double d;
            double result = 0.0;
            if (t < 0.0) {
                return result;
            }
            double stepLength = 1.0 / (double)steps;
            result = (double)(steps - 1) * stepLength;
            if (t > d) {
                return result;
            }
            int leftBorderIndex = 0;
            int rightBorderIndex = steps - 1;
            while (rightBorderIndex - leftBorderIndex != 1) {
                int testIndex = leftBorderIndex + (rightBorderIndex - leftBorderIndex) / 2;
                if (t >= (double)testIndex * stepLength) {
                    leftBorderIndex = testIndex;
                    continue;
                }
                rightBorderIndex = testIndex;
            }
            return (double)leftBorderIndex * stepLength;
        };
    }

    public static double lerpWithOverride(AzAnimationPoint animationPoint, AzEasingType override) {
        AzEasingType easingType = override;
        if (override == null) {
            easingType = animationPoint.keyframe() == null ? AzEasingTypes.LINEAR : animationPoint.keyframe().easingType();
        }
        return easingType.apply(animationPoint);
    }
}

