/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.render;

import java.util.function.Function;
import java.util.function.Supplier;
import mod.azure.azurelib.rewrite.animation.AzAnimator;
import mod.azure.azurelib.rewrite.animation.AzAnimatorAccessor;
import mod.azure.azurelib.rewrite.model.AzBakedModel;
import mod.azure.azurelib.rewrite.model.cache.AzBakedModelCache;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AzProvider<T> {
    private final Supplier<AzAnimator<T>> animatorSupplier;
    private final Function<T, class_2960> modelLocationProvider;

    public AzProvider(Supplier<AzAnimator<T>> animatorSupplier, Function<T, class_2960> modelLocationProvider) {
        this.animatorSupplier = animatorSupplier;
        this.modelLocationProvider = modelLocationProvider;
    }

    @Nullable
    public AzBakedModel provideBakedModel(@NotNull T animatable) {
        class_2960 modelResourceLocation = this.modelLocationProvider.apply(animatable);
        return AzBakedModelCache.getInstance().getNullable(modelResourceLocation);
    }

    @Nullable
    public AzAnimator<T> provideAnimator(T animatable) {
        AzAnimatorAccessor<T> accessor = AzAnimatorAccessor.cast(animatable);
        AzAnimator<T> cachedAnimator = accessor.getAnimatorOrNull();
        if (cachedAnimator == null && (cachedAnimator = this.animatorSupplier.get()) != null) {
            cachedAnimator.registerControllers(cachedAnimator.getAnimationControllerContainer());
            accessor.setAnimator(cachedAnimator);
        }
        return cachedAnimator;
    }
}

