/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.render;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import mod.azure.azurelib.rewrite.animation.AzAnimator;
import mod.azure.azurelib.rewrite.render.AzRendererPipelineContext;
import mod.azure.azurelib.rewrite.render.layer.AzRenderLayer;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class AzRendererConfig<T> {
    private final Supplier<@Nullable AzAnimator<T>> animatorProvider;
    private final Function<T, class_2960> modelLocationProvider;
    private final Function<T, class_1921> renderTypeFunction;
    private final Function<AzRendererPipelineContext<T>, AzRendererPipelineContext<T>> preRenderEntry;
    private final Function<AzRendererPipelineContext<T>, AzRendererPipelineContext<T>> postRenderEntry;
    private final List<AzRenderLayer<T>> renderLayers;
    private final Function<T, class_2960> textureLocationProvider;
    private final float scaleHeight;
    private final float scaleWidth;

    public AzRendererConfig(Supplier<AzAnimator<T>> animatorProvider, Function<T, class_2960> modelLocationProvider, Function<T, class_1921> renderTypeFunction, List<AzRenderLayer<T>> renderLayers, Function<AzRendererPipelineContext<T>, AzRendererPipelineContext<T>> preRenderEntry, Function<AzRendererPipelineContext<T>, AzRendererPipelineContext<T>> postRenderEntry, Function<T, class_2960> textureLocationProvider, float scaleHeight, float scaleWidth) {
        this.animatorProvider = animatorProvider;
        this.modelLocationProvider = modelLocationProvider;
        this.renderTypeFunction = renderTypeFunction;
        this.renderLayers = Collections.unmodifiableList(renderLayers);
        this.preRenderEntry = preRenderEntry;
        this.postRenderEntry = postRenderEntry;
        this.textureLocationProvider = textureLocationProvider;
        this.scaleHeight = scaleHeight;
        this.scaleWidth = scaleWidth;
    }

    @Nullable
    public AzAnimator<T> createAnimator() {
        return this.animatorProvider.get();
    }

    public class_2960 modelLocation(T animatable) {
        return this.modelLocationProvider.apply(animatable);
    }

    public class_2960 textureLocation(T animatable) {
        return this.textureLocationProvider.apply(animatable);
    }

    public class_1921 getRenderType(T entity) {
        return this.renderTypeFunction.apply(entity);
    }

    public List<AzRenderLayer<T>> renderLayers() {
        return this.renderLayers;
    }

    public AzRendererPipelineContext<T> preRenderEntry(AzRendererPipelineContext<T> animatable) {
        return this.preRenderEntry.apply(animatable);
    }

    public AzRendererPipelineContext<T> postRenderEntry(AzRendererPipelineContext<T> animatable) {
        return this.postRenderEntry.apply(animatable);
    }

    public float scaleHeight() {
        return this.scaleHeight;
    }

    public float scaleWidth() {
        return this.scaleWidth;
    }

    public static class Builder<T> {
        protected final Function<T, class_2960> modelLocationProvider;
        protected Function<T, class_1921> renderTypeProvider;
        public final List<AzRenderLayer<T>> renderLayers;
        protected Function<AzRendererPipelineContext<T>, AzRendererPipelineContext<T>> preRenderEntry;
        protected Function<AzRendererPipelineContext<T>, AzRendererPipelineContext<T>> postRenderEntry;
        protected final Function<T, class_2960> textureLocationProvider;
        protected Supplier<@Nullable AzAnimator<T>> animatorProvider = () -> null;
        protected float scaleHeight;
        protected float scaleWidth;

        protected Builder(Function<T, class_2960> modelLocationProvider, Function<T, class_2960> textureLocationProvider) {
            this.modelLocationProvider = modelLocationProvider;
            this.renderTypeProvider = $ -> class_1921.method_23578((class_2960)((class_2960)textureLocationProvider.apply($)));
            this.renderLayers = new ObjectArrayList();
            this.preRenderEntry = $ -> $;
            this.postRenderEntry = $ -> $;
            this.textureLocationProvider = textureLocationProvider;
            this.scaleHeight = 1.0f;
            this.scaleWidth = 1.0f;
        }

        public Builder<T> setPrerenderEntry(Function<AzRendererPipelineContext<T>, AzRendererPipelineContext<T>> preRenderEntry) {
            this.preRenderEntry = preRenderEntry;
            return this;
        }

        public Builder<T> setPostRenderEntry(Function<AzRendererPipelineContext<T>, AzRendererPipelineContext<T>> postRenderEntry) {
            this.postRenderEntry = postRenderEntry;
            return this;
        }

        public Builder<T> setAnimatorProvider(Supplier<@Nullable AzAnimator<T>> animatorProvider) {
            this.animatorProvider = animatorProvider;
            return this;
        }

        public Builder<T> addRenderLayer(AzRenderLayer<T> renderLayer) {
            this.renderLayers.add(renderLayer);
            return this;
        }

        public Builder<T> setScale(float scale) {
            return this.setScale(scale, scale);
        }

        public Builder<T> setScale(float scaleWidth, float scaleHeight) {
            this.scaleHeight = scaleHeight;
            this.scaleWidth = scaleWidth;
            return this;
        }

        public AzRendererConfig<T> build() {
            return new AzRendererConfig<T>(this.animatorProvider, this.modelLocationProvider, this.renderTypeProvider, this.renderLayers, this.preRenderEntry, this.postRenderEntry, this.textureLocationProvider, this.scaleHeight, this.scaleWidth);
        }
    }
}

