/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.render.entity;

import mod.azure.azurelib.rewrite.animation.impl.AzEntityAnimator;
import mod.azure.azurelib.rewrite.model.AzBakedModel;
import mod.azure.azurelib.rewrite.render.AzProvider;
import mod.azure.azurelib.rewrite.render.entity.AzEntityNameRenderUtil;
import mod.azure.azurelib.rewrite.render.entity.AzEntityRendererConfig;
import mod.azure.azurelib.rewrite.render.entity.AzEntityRendererPipeline;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_897;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AzEntityRenderer<T extends class_1297>
extends class_897<T> {
    private final AzEntityRendererConfig<T> config;
    private final AzProvider<T> provider;
    private final AzEntityRendererPipeline<T> rendererPipeline;
    @Nullable
    private AzEntityAnimator<T> reusedAzEntityAnimator;

    protected AzEntityRenderer(AzEntityRendererConfig<T> config, class_5617.class_5618 context) {
        super(context);
        this.config = config;
        this.provider = new AzProvider<class_1297>(config::createAnimator, config::modelLocation);
        this.rendererPipeline = this.createPipeline(config);
    }

    protected AzEntityRendererPipeline<T> createPipeline(AzEntityRendererConfig<T> config) {
        return new AzEntityRendererPipeline<T>(config, this);
    }

    @NotNull
    public final class_2960 method_3931(@NotNull T animatable) {
        return this.config.textureLocation(animatable);
    }

    public void superRender(@NotNull T entity, float entityYaw, float partialTick, @NotNull class_4587 poseStack, @NotNull class_4597 bufferSource, int packedLight) {
        super.method_3936(entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
    }

    public void method_3936(@NotNull T entity, float entityYaw, float partialTick, @NotNull class_4587 poseStack, @NotNull class_4597 bufferSource, int packedLight) {
        AzEntityAnimator cachedEntityAnimator = (AzEntityAnimator)this.provider.provideAnimator(entity);
        AzBakedModel azBakedModel = this.provider.provideBakedModel(entity);
        if (cachedEntityAnimator != null && azBakedModel != null) {
            cachedEntityAnimator.setActiveModel(azBakedModel);
        }
        this.reusedAzEntityAnimator = cachedEntityAnimator;
        this.rendererPipeline.render(poseStack, azBakedModel, entity, bufferSource, null, null, entityYaw, partialTick, packedLight);
    }

    public boolean method_3921(@NotNull T entity) {
        return AzEntityNameRenderUtil.shouldShowName(this.field_4676, entity);
    }

    public int method_24087(@NotNull T entity, @NotNull class_2338 pos) {
        return super.method_24087(entity, pos);
    }

    public AzEntityAnimator<T> getAnimator() {
        return this.reusedAzEntityAnimator;
    }

    public AzEntityRendererConfig<T> config() {
        return this.config;
    }
}

