/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.sblforked.api.core;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import mod.azure.azurelib.sblforked.api.SmartBrainOwner;
import mod.azure.azurelib.sblforked.api.core.BrainActivityGroup;
import mod.azure.azurelib.sblforked.api.core.behaviour.GroupBehaviour;
import mod.azure.azurelib.sblforked.api.core.schedule.SmartBrainSchedule;
import mod.azure.azurelib.sblforked.api.core.sensor.ExtendedSensor;
import mod.azure.azurelib.sblforked.object.BrainBehaviourConsumer;
import mod.azure.azurelib.sblforked.object.BrainBehaviourPredicate;
import mod.azure.azurelib.sblforked.util.BrainUtils;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_3218;
import net.minecraft.class_4095;
import net.minecraft.class_4097;
import net.minecraft.class_4103;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4148;
import net.minecraft.class_4149;
import net.minecraft.class_4168;
import net.minecraft.class_4170;
import net.minecraft.class_4831;
import net.minecraft.class_7893;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.Nullable;

public class SmartBrain<E extends class_1309>
extends class_4095<E> {
    private final List<class_4140<?>> expirableMemories = new ObjectArrayList();
    private final List<ActivityBehaviours<E>> behaviours = new ObjectArrayList();
    private final List<Pair<class_4149<ExtendedSensor<? super E>>, ExtendedSensor<? super E>>> sensors = new ObjectArrayList();
    private SmartBrainSchedule schedule = null;
    private boolean sortBehaviours = false;

    public SmartBrain(List<class_4140<?>> memories, List<? extends ExtendedSensor<E>> sensors, @Nullable List<BrainActivityGroup<E>> taskList) {
        super(memories, (Collection)ImmutableList.of(), ImmutableList.of(), SmartBrain::emptyBrainCodec);
        for (ExtendedSensor<E> extendedSensor : sensors) {
            this.sensors.add(Pair.of(extendedSensor.type(), extendedSensor));
        }
        if (taskList != null) {
            for (BrainActivityGroup brainActivityGroup : taskList) {
                this.addActivity(brainActivityGroup);
            }
        }
    }

    public void method_19542(class_3218 level, E entity) {
        entity.method_37908().method_16107().method_15396("SmartBrain");
        if (this.sortBehaviours) {
            this.behaviours.sort(Comparator.comparingInt(ActivityBehaviours::priority));
        }
        this.method_27075();
        this.tickSensors(level, entity);
        this.checkForNewBehaviours(level, entity);
        this.tickRunningBehaviours(level, entity);
        this.findAndSetActiveActivity(entity);
        entity.method_37908().method_16107().method_15407();
        if (entity instanceof class_1308) {
            class_1308 mob = (class_1308)entity;
            mob.method_19540(BrainUtils.hasMemory((class_1309)mob, class_4140.field_22355));
        }
    }

    private void findAndSetActiveActivity(E entity) {
        class_4168 scheduledActivity;
        if (this.schedule != null && (scheduledActivity = this.schedule.tick((class_1309)entity)) != null && !this.method_35059().contains(scheduledActivity) && this.method_18874(scheduledActivity)) {
            this.method_18880(scheduledActivity);
            return;
        }
        this.method_24531(((SmartBrainOwner)entity).getActivityPriorities());
    }

    private void tickSensors(class_3218 level, E entity) {
        for (Pair<class_4149<ExtendedSensor<? super E>>, ExtendedSensor<? super E>> pair : this.sensors) {
            ((ExtendedSensor)((Object)pair.getSecond())).method_19100(level, entity);
        }
    }

    private void checkForNewBehaviours(class_3218 level, E entity) {
        long gameTime = level.method_8510();
        for (ActivityBehaviours<E> behaviourGroup : this.behaviours) {
            for (Pair pair : behaviourGroup.behaviours) {
                if (!this.method_35059().contains(pair.getFirst())) continue;
                for (class_7893 behaviour : (List)pair.getSecond()) {
                    if (behaviour.method_18921() != class_4097.class_4098.field_18337) continue;
                    behaviour.method_18922(level, entity, gameTime);
                }
            }
        }
    }

    private void tickRunningBehaviours(class_3218 level, E entity) {
        long gameTime = level.method_8510();
        for (ActivityBehaviours<E> behaviourGroup : this.behaviours) {
            for (Pair pair : behaviourGroup.behaviours) {
                for (class_7893 behaviour : (List)pair.getSecond()) {
                    if (behaviour.method_18921() != class_4097.class_4098.field_18338) continue;
                    behaviour.method_18923(level, entity, gameTime);
                }
            }
        }
    }

    public void method_27075() {
        Iterator<class_4140<?>> expirable = this.expirableMemories.iterator();
        while (expirable.hasNext()) {
            class_4140<?> memoryType = expirable.next();
            Optional memory = (Optional)this.field_18322.get(memoryType);
            if (memory.isEmpty()) {
                expirable.remove();
                continue;
            }
            class_4831 value = (class_4831)memory.get();
            if (!value.method_24914()) {
                expirable.remove();
                continue;
            }
            if (value.method_24634()) {
                expirable.remove();
                this.method_18875(memoryType);
                continue;
            }
            value.method_24913();
        }
    }

    public void method_18900(class_3218 level, E entity) {
        long gameTime = level.method_8510();
        for (ActivityBehaviours<E> behaviourGroup : this.behaviours) {
            for (Pair pair : behaviourGroup.behaviours) {
                for (class_7893 behaviour : (List)pair.getSecond()) {
                    if (behaviour.method_18921() != class_4097.class_4098.field_18338) continue;
                    behaviour.method_18925(level, entity, gameTime);
                }
            }
        }
    }

    public <U> Optional<U> method_18904(class_4140<U> type) {
        return this.field_18322.computeIfAbsent(type, key -> Optional.empty()).map(class_4831::method_24637);
    }

    public <U> void method_24535(class_4140<U> memoryType, Optional<? extends class_4831<?>> memory) {
        Collection collection;
        Object object;
        if (memory.isPresent() && (object = memory.get().method_24637()) instanceof Collection && (collection = (Collection)object).isEmpty()) {
            memory = Optional.empty();
        }
        this.field_18322.put(memoryType, memory);
        if (memory.isPresent() && memory.get().method_24914() && !this.expirableMemories.contains(memoryType)) {
            this.expirableMemories.add(memoryType);
        }
    }

    public <U> boolean method_29519(class_4140<U> memoryType, U memory) {
        Optional<U> value = this.method_18904(memoryType);
        return value.isPresent() && value.get().equals(memory);
    }

    private static <E extends class_1309> Codec<class_4095<E>> emptyBrainCodec() {
        MutableObject brainCodec = new MutableObject();
        brainCodec.setValue((Object)Codec.unit(() -> new class_4095((Collection)ImmutableList.of(), (Collection)ImmutableList.of(), ImmutableList.of(), () -> ((MutableObject)brainCodec).getValue())));
        return (Codec)brainCodec.getValue();
    }

    private static <E extends class_1309> List<? extends class_4149<? extends class_4148<? super E>>> convertSensorsToTypes(List<? extends ExtendedSensor<E>> sensors) {
        ObjectArrayList types = new ObjectArrayList(sensors.size());
        for (ExtendedSensor<E> sensor : sensors) {
            types.add(sensor.type());
        }
        return types;
    }

    public class_4095<E> method_18911() {
        SmartBrain<E> brain = new SmartBrain<E>(this.field_18322.keySet().stream().toList(), this.sensors.stream().map(pair -> (ExtendedSensor)((Object)((Object)pair.getSecond()))).toList(), null);
        for (Map.Entry entry : this.field_18322.entrySet()) {
            class_4140 memoryType = (class_4140)entry.getKey();
            if (!((Optional)entry.getValue()).isPresent()) continue;
            brain.field_18322.put(memoryType, (Optional)entry.getValue());
        }
        return brain;
    }

    public List<class_7893<? super E>> method_27074() {
        ObjectArrayList runningBehaviours = new ObjectArrayList();
        for (ActivityBehaviours<E> behaviourGroup : this.behaviours) {
            for (Pair pair : behaviourGroup.behaviours) {
                for (class_7893 behaviour : (List)pair.getSecond()) {
                    if (behaviour.method_18921() != class_4097.class_4098.field_18338) continue;
                    runningBehaviours.add(behaviour);
                }
            }
        }
        return runningBehaviours;
    }

    public Stream<class_7893<? super E>> getBehaviours() {
        return this.behaviours.stream().map(ActivityBehaviours::behaviours).flatMap(list -> list.stream().map(Pair::getSecond).flatMap(Collection::stream));
    }

    public void method_35060() {
        this.behaviours.clear();
    }

    public void method_24530(class_4168 activity, ImmutableList<? extends Pair<Integer, ? extends class_7893<? super E>>> tasks, Set<Pair<class_4140<?>, class_4141>> memorieStatuses, Set<class_4140<?>> memoryTypes) {
        this.field_18326.put(activity, memorieStatuses);
        if (!memoryTypes.isEmpty()) {
            this.field_22282.put(activity, memoryTypes);
        }
        for (Pair pair : tasks) {
            this.addBehaviour((Integer)pair.getFirst(), activity, (class_7893)pair.getSecond());
        }
    }

    public void addActivity(BrainActivityGroup<E> activityGroup) {
        this.method_24530(activityGroup.getActivity(), activityGroup.pairBehaviourPriorities(), activityGroup.getActivityStartMemoryConditions(), activityGroup.getWipedMemoriesOnFinish());
    }

    public void addBehaviour(int priority, class_4168 activity, class_7893<? super E> behaviour) {
        for (ActivityBehaviours<E> behaviourGroup : this.behaviours) {
            if (behaviourGroup.priority != priority) continue;
            for (Pair pair : behaviourGroup.behaviours) {
                if (pair.getFirst() != activity) continue;
                ((List)pair.getSecond()).add(behaviour);
                return;
            }
            behaviourGroup.behaviours.add(Pair.of((Object)activity, (Object)ObjectArrayList.of((Object[])new class_7893[]{behaviour})));
            return;
        }
        this.behaviours.add(new ActivityBehaviours(priority, ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)activity, (Object)ObjectArrayList.of((Object[])new class_7893[]{behaviour}))})));
        this.sortBehaviours = true;
    }

    public void removeBehaviour(E entity, BrainBehaviourPredicate predicate) {
        for (ActivityBehaviours<E> behaviourGroup : this.behaviours) {
            int priority = behaviourGroup.priority;
            for (Pair pair : behaviourGroup.behaviours) {
                class_4168 activity = (class_4168)pair.getFirst();
                Iterator iterator = ((List)pair.getSecond()).iterator();
                while (iterator.hasNext()) {
                    class_7893 behaviour = (class_7893)iterator.next();
                    SmartBrain.checkBehaviour(priority, activity, behaviour, null, predicate, () -> {
                        if (behaviour.method_18921() == class_4097.class_4098.field_18338) {
                            behaviour.method_18925((class_3218)entity.method_37908(), entity, entity.method_37908().method_8510());
                        }
                        iterator.remove();
                    });
                }
            }
        }
    }

    public SmartBrain<E> setSchedule(SmartBrainSchedule schedule) {
        this.schedule = schedule;
        return this;
    }

    public SmartBrainSchedule getSchedule() {
        return this.schedule;
    }

    public void scheduleTask(E brainOwner, int delay, Consumer<E> task) {
        if (this.schedule == null) {
            this.schedule = new SmartBrainSchedule();
        }
        this.schedule.scheduleTask((class_1309)brainOwner, delay, task);
    }

    private static <E extends class_1309> void checkBehaviour(int priority, class_4168 activity, class_7893<E> behaviour, @Nullable class_7893<E> parentBehaviour, BrainBehaviourPredicate predicate, Runnable callback) {
        if (predicate.isBehaviour(priority, activity, behaviour, parentBehaviour)) {
            callback.run();
        } else if (behaviour instanceof class_4103) {
            class_4103 groupBehaviour = (class_4103)behaviour;
            Iterator childBehaviourIterator = groupBehaviour.field_18347.iterator();
            while (childBehaviourIterator.hasNext()) {
                SmartBrain.checkBehaviour(priority, activity, (class_7893)childBehaviourIterator.next(), groupBehaviour, predicate, childBehaviourIterator::remove);
            }
            if (!groupBehaviour.field_18347.iterator().hasNext()) {
                callback.run();
            }
        } else if (behaviour instanceof GroupBehaviour) {
            GroupBehaviour groupBehaviour = (GroupBehaviour)behaviour;
            Iterator childBehaviourIterator = groupBehaviour.getBehaviours();
            while (childBehaviourIterator.hasNext()) {
                SmartBrain.checkBehaviour(priority, activity, (class_7893)childBehaviourIterator.next(), groupBehaviour, predicate, childBehaviourIterator::remove);
            }
            if (!groupBehaviour.getBehaviours().hasNext()) {
                callback.run();
            }
        }
    }

    public void forEachBehaviour(BrainBehaviourConsumer consumer) {
        for (ActivityBehaviours<E> behavioursGroup : this.behaviours) {
            int priority = behavioursGroup.priority();
            for (Pair<class_4168, List<class_7893<E>>> behaviourList : behavioursGroup.behaviours()) {
                class_4168 activity = (class_4168)behaviourList.getFirst();
                for (class_7893 behaviour : (List)behaviourList.getSecond()) {
                    SmartBrain.consumeBehaviour(priority, activity, behaviour, null, consumer);
                }
            }
        }
    }

    private static <E extends class_1309> void consumeBehaviour(int priority, class_4168 activity, class_7893<E> behaviour, @Nullable class_7893<E> parentBehaviour, BrainBehaviourConsumer consumer) {
        consumer.consume(priority, activity, behaviour, parentBehaviour);
        if (behaviour instanceof class_4103) {
            class_4103 groupBehaviour = (class_4103)behaviour;
            groupBehaviour.field_18347.method_35094().forEach(childBehaviour -> SmartBrain.consumeBehaviour(priority, activity, childBehaviour, groupBehaviour, consumer));
        } else if (behaviour instanceof GroupBehaviour) {
            GroupBehaviour groupBehaviour = (GroupBehaviour)behaviour;
            groupBehaviour.getBehaviours().forEachRemaining(childBehaviour -> SmartBrain.consumeBehaviour(priority, activity, childBehaviour, groupBehaviour, consumer));
        }
    }

    public void addSensor(ExtendedSensor<E> sensor) {
        class_4149<ExtendedSensor<?>> sensorType = sensor.type();
        this.sensors.add(Pair.of(sensorType, sensor));
    }

    @Deprecated(forRemoval=true)
    public final void method_18884(class_4170 schedule) {
    }

    private record ActivityBehaviours<E extends class_1309>(int priority, List<Pair<class_4168, List<class_7893<? super E>>>> behaviours) {
    }
}

