/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.sblforked.api.core.behaviour;

import java.util.function.Consumer;
import mod.azure.azurelib.sblforked.api.core.behaviour.ExtendedBehaviour;
import net.minecraft.class_1309;
import net.minecraft.class_3218;

public abstract class DelayedBehaviour<E extends class_1309>
extends ExtendedBehaviour<E> {
    protected final int delayTime;
    protected long delayFinishedAt = 0L;
    protected Consumer<E> delayedCallback = entity -> {};

    public DelayedBehaviour(int delayTicks) {
        this.delayTime = delayTicks;
        this.runFor(entity -> Math.max(delayTicks, 60));
    }

    public final DelayedBehaviour<E> whenActivating(Consumer<E> callback) {
        this.delayedCallback = callback;
        return this;
    }

    @Override
    protected final void method_18920(class_3218 level, E entity, long gameTime) {
        if (this.delayTime > 0) {
            this.delayFinishedAt = gameTime + (long)this.delayTime;
            super.method_18920(level, entity, gameTime);
        } else {
            super.method_18920(level, entity, gameTime);
            this.doDelayedAction(entity);
        }
    }

    @Override
    protected final void method_18926(class_3218 level, E entity, long gameTime) {
        super.method_18926(level, entity, gameTime);
        this.delayFinishedAt = 0L;
    }

    @Override
    protected boolean shouldKeepRunning(E entity) {
        return this.delayFinishedAt >= entity.method_37908().method_8510();
    }

    @Override
    protected final void method_18924(class_3218 level, E entity, long gameTime) {
        super.method_18924(level, entity, gameTime);
        if (this.delayFinishedAt <= gameTime) {
            this.doDelayedAction(entity);
            this.delayedCallback.accept(entity);
        }
    }

    protected void doDelayedAction(E entity) {
    }
}

