/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.client;

import com.stal111.forbidden_arcanus.ForbiddenArcanus;
import com.stal111.forbidden_arcanus.client.gui.label.FlyingLabel;
import com.stal111.forbidden_arcanus.client.gui.label.JarFlyingLabel;
import com.stal111.forbidden_arcanus.client.gui.label.QuantumCatcherFlyingLabel;
import com.stal111.forbidden_arcanus.client.gui.overlay.AurealMeterOverlay;
import com.stal111.forbidden_arcanus.client.gui.overlay.FlyingLabelOverlay;
import com.stal111.forbidden_arcanus.client.gui.screen.ClibanoScreen;
import com.stal111.forbidden_arcanus.client.gui.screen.HephaestusForgeScreen;
import com.stal111.forbidden_arcanus.client.gui.screen.research.ResearchScreen;
import com.stal111.forbidden_arcanus.client.model.FAModelLayers;
import com.stal111.forbidden_arcanus.client.particle.AurealMoteParticle;
import com.stal111.forbidden_arcanus.client.particle.EssenceDropParticle;
import com.stal111.forbidden_arcanus.client.particle.HugeMagicExplosionParticle;
import com.stal111.forbidden_arcanus.client.particle.MagneticGlowProvider;
import com.stal111.forbidden_arcanus.client.particle.SoulParticle;
import com.stal111.forbidden_arcanus.client.renderer.block.BlackHoleRenderer;
import com.stal111.forbidden_arcanus.client.renderer.block.EssenceUtremJarRenderer;
import com.stal111.forbidden_arcanus.client.renderer.block.HephaestusForgeRenderer;
import com.stal111.forbidden_arcanus.client.renderer.block.PedestalRenderer;
import com.stal111.forbidden_arcanus.client.renderer.block.QuantumInjectorRenderer;
import com.stal111.forbidden_arcanus.client.renderer.block.ResearchDeskRenderer;
import com.stal111.forbidden_arcanus.client.renderer.entity.BoomArrowRenderer;
import com.stal111.forbidden_arcanus.client.renderer.entity.CrimsonLightningBoltRenderer;
import com.stal111.forbidden_arcanus.client.renderer.entity.DarkTraderRenderer;
import com.stal111.forbidden_arcanus.client.renderer.entity.DracoArcanusArrowRenderer;
import com.stal111.forbidden_arcanus.client.renderer.entity.EnergyBallRenderer;
import com.stal111.forbidden_arcanus.client.renderer.entity.LostSoulRenderer;
import com.stal111.forbidden_arcanus.client.renderer.entity.ModBoatRenderer;
import com.stal111.forbidden_arcanus.client.tooltip.CapacityBucketTooltip;
import com.stal111.forbidden_arcanus.client.tooltip.ClientCapacityBucketTooltip;
import com.stal111.forbidden_arcanus.common.block.skull.ObsidianSkullType;
import com.stal111.forbidden_arcanus.common.essence.EssenceHelper;
import com.stal111.forbidden_arcanus.common.essence.EssenceStorage;
import com.stal111.forbidden_arcanus.common.item.SpectralEyeAmuletItem;
import com.stal111.forbidden_arcanus.core.init.ModBlockEntities;
import com.stal111.forbidden_arcanus.core.init.ModEntities;
import com.stal111.forbidden_arcanus.core.init.ModItems;
import com.stal111.forbidden_arcanus.core.init.ModParticles;
import com.stal111.forbidden_arcanus.core.init.other.ModMenuTypes;
import com.stal111.forbidden_arcanus.core.init.other.ModWoodTypes;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.model.SkullModel;
import net.minecraft.client.particle.HugeExplosionParticle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.SkullBlockRenderer;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.valhelsia.valhelsia_core.api.client.ClientSetupHelper;

public class ClientSetup {
    public static final List<FlyingLabel<?>> FLYING_LABELS = new ArrayList();
    public static final ItemPropertyFunction ESSENCE_AMOUNT_PROPERTY_FUNCTION = (stack, level, entity, seed) -> EssenceHelper.getEssenceStorage(stack).map(EssenceStorage::getFillPercentage).orElse(Float.valueOf(0.0f)).floatValue();

    public ClientSetup(ClientSetupHelper helper, IEventBus modEventBus) {
        Minecraft minecraft = Minecraft.getInstance();
        helper.registerBlockEntityRenderer(ModBlockEntities.PEDESTAL, PedestalRenderer::new);
        helper.registerBlockEntityRenderer(ModBlockEntities.BLACK_HOLE, BlackHoleRenderer::new);
        helper.registerBlockEntityRenderer(ModBlockEntities.ESSENCE_UTREM_JAR, EssenceUtremJarRenderer::new);
        helper.registerBlockEntityRenderer(ModBlockEntities.OBSIDIAN_SKULL, SkullBlockRenderer::new);
        helper.registerBlockEntityRenderer(ModBlockEntities.HEPHAESTUS_FORGE, HephaestusForgeRenderer::new);
        helper.registerBlockEntityRenderer(ModBlockEntities.RESEARCH_DESK, ResearchDeskRenderer::new);
        helper.registerBlockEntityRenderer(ModBlockEntities.QUANTUM_INJECTOR, QuantumInjectorRenderer::new);
        helper.registerEntityRenderer(ModEntities.BOOM_ARROW, BoomArrowRenderer::new);
        helper.registerEntityRenderer(ModEntities.DRACO_ARCANUS_ARROW, DracoArcanusArrowRenderer::new);
        helper.registerEntityRenderer(ModEntities.ENERGY_BALL, EnergyBallRenderer::new);
        helper.registerEntityRenderer(ModEntities.CRIMSON_LIGHTNING_BOLT, CrimsonLightningBoltRenderer::new);
        helper.registerEntityRenderer(ModEntities.BOAT, context -> new ModBoatRenderer(context, false));
        helper.registerEntityRenderer(ModEntities.CHEST_BOAT, context -> new ModBoatRenderer(context, true));
        helper.registerEntityRenderer(ModEntities.LOST_SOUL, context -> new LostSoulRenderer(context, ForbiddenArcanus.location("textures/entity/lost_soul/lost_soul.png")));
        helper.registerEntityRenderer(ModEntities.CORRUPT_LOST_SOUL, context -> new LostSoulRenderer(context, ForbiddenArcanus.location("textures/entity/lost_soul/corrupt_lost_soul.png")));
        helper.registerEntityRenderer(ModEntities.ENCHANTED_LOST_SOUL, context -> new LostSoulRenderer(context, ForbiddenArcanus.location("textures/entity/lost_soul/enchanted_lost_soul.png")));
        helper.registerEntityRenderer(ModEntities.AUREAL_BOTTLE, ThrownItemRenderer::new);
        helper.registerEntityRenderer(ModEntities.DARK_TRADER, DarkTraderRenderer::new);
        helper.registerSkullModel((SkullBlock.Type)ObsidianSkullType.DEFAULT, modelSet -> new SkullModel(modelSet.bakeLayer(FAModelLayers.OBSIDIAN_SKULL_LAYER)));
        helper.registerSkullModel((SkullBlock.Type)ObsidianSkullType.CRACKED, modelSet -> new SkullModel(modelSet.bakeLayer(FAModelLayers.OBSIDIAN_SKULL_LAYER)));
        helper.registerSkullModel((SkullBlock.Type)ObsidianSkullType.FRAGMENTED, modelSet -> new SkullModel(modelSet.bakeLayer(FAModelLayers.OBSIDIAN_SKULL_LAYER)));
        helper.registerSkullModel((SkullBlock.Type)ObsidianSkullType.FADING, modelSet -> new SkullModel(modelSet.bakeLayer(FAModelLayers.OBSIDIAN_SKULL_LAYER)));
        helper.registerSkullModel((SkullBlock.Type)ObsidianSkullType.AUREALIC, modelSet -> new SkullModel(modelSet.bakeLayer(FAModelLayers.DETAILED_OBSIDIAN_SKULL_LAYER)));
        helper.registerSkullModel((SkullBlock.Type)ObsidianSkullType.ETERNAL, modelSet -> new SkullModel(modelSet.bakeLayer(FAModelLayers.DETAILED_OBSIDIAN_SKULL_LAYER)));
        helper.registerScreen(ModMenuTypes.HEPHAESTUS_FORGE, HephaestusForgeScreen::new);
        helper.registerScreen(ModMenuTypes.CLIBANO, ClibanoScreen::new);
        helper.registerScreen(ModMenuTypes.RESEARCH_DESK, ResearchScreen::new);
        modEventBus.addListener(this::onClientSetup);
        modEventBus.addListener(this::onRegisterGuiOverlays);
        modEventBus.addListener(this::onRegisterTooltipComponents);
        modEventBus.addListener(this::onRegisterParticleProviders);
    }

    @SubscribeEvent
    public void onClientSetup(FMLClientSetupEvent event) {
        this.registerCosmetics();
        event.enqueueWork(() -> {
            Sheets.addWoodType((WoodType)ModWoodTypes.FUNGYSS);
            Sheets.addWoodType((WoodType)ModWoodTypes.AURUM);
            Sheets.addWoodType((WoodType)ModWoodTypes.EDELWOOD);
            for (ObsidianSkullType skullType : ObsidianSkullType.values()) {
                SkullBlockRenderer.SKIN_BY_TYPE.put(skullType, skullType.getTextureLocation());
            }
            ItemProperties.register((Item)((Item)ModItems.SPECTRAL_EYE_AMULET.get()), (ResourceLocation)ForbiddenArcanus.location("deactivated"), (stack, level, entity, seed) -> entity != null && SpectralEyeAmuletItem.isActive(stack) ? 0.0f : 1.0f);
            ItemProperties.register((Item)((Item)ModItems.BLOOD_TEST_TUBE.get()), (ResourceLocation)ForbiddenArcanus.location("amount"), (ItemPropertyFunction)ESSENCE_AMOUNT_PROPERTY_FUNCTION);
            ItemProperties.register((Item)((Item)ModItems.AUREAL_TANK.get()), (ResourceLocation)ForbiddenArcanus.location("amount"), (ItemPropertyFunction)ESSENCE_AMOUNT_PROPERTY_FUNCTION);
            ItemProperties.register((Item)((Item)ModItems.AUREAL_TANK.get()), (ResourceLocation)ForbiddenArcanus.location("max"), (stack, level, entity, seed) -> EssenceHelper.getEssenceStorage(stack).map(essenceStorage -> Float.valueOf(essenceStorage.limit() == 3000 ? 1.0f : 0.0f)).orElse(Float.valueOf(0.0f)).floatValue());
        });
        FLYING_LABELS.add(new JarFlyingLabel());
        FLYING_LABELS.add(new QuantumCatcherFlyingLabel());
    }

    private void registerCosmetics() {
    }

    @SubscribeEvent
    public void onRegisterGuiOverlays(RegisterGuiLayersEvent event) {
        event.registerAbove(VanillaGuiLayers.EXPERIENCE_BAR, ForbiddenArcanus.location("aureal_meter"), (LayeredDraw.Layer)new AurealMeterOverlay());
        event.registerAbove(VanillaGuiLayers.EXPERIENCE_BAR, ForbiddenArcanus.location("flying_label"), (LayeredDraw.Layer)new FlyingLabelOverlay());
    }

    @SubscribeEvent
    public void onRegisterTooltipComponents(RegisterClientTooltipComponentFactoriesEvent event) {
        event.register(CapacityBucketTooltip.class, ClientCapacityBucketTooltip::new);
    }

    @SubscribeEvent
    public void onRegisterParticleProviders(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)ModParticles.SOUL.get(), SoulParticle.Factory::new);
        event.registerSpriteSet((ParticleType)ModParticles.AUREAL_MOTE.get(), AurealMoteParticle.Factory::new);
        event.registerSpriteSet((ParticleType)ModParticles.MAGIC_EXPLOSION.get(), HugeExplosionParticle.Provider::new);
        event.registerSpecial((ParticleType)ModParticles.HUGE_MAGIC_EXPLOSION.get(), (ParticleProvider)new HugeMagicExplosionParticle.Factory());
        event.registerSpriteSet((ParticleType)ModParticles.MAGNETIC_GLOW.get(), MagneticGlowProvider::new);
        event.registerSpriteSet((ParticleType)ModParticles.AUREAL_DROP.get(), EssenceDropParticle.Provider::new);
        event.registerSpriteSet((ParticleType)ModParticles.SOULS_DROP.get(), EssenceDropParticle.Provider::new);
        event.registerSpriteSet((ParticleType)ModParticles.BLOOD_DROP.get(), EssenceDropParticle.Provider::new);
        event.registerSpriteSet((ParticleType)ModParticles.EXPERIENCE_DROP.get(), EssenceDropParticle.Provider::new);
    }
}

