/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.client.gui.label;

import com.mojang.blaze3d.vertex.PoseStack;
import com.stal111.forbidden_arcanus.client.gui.label.BlockFlyingLabel;
import com.stal111.forbidden_arcanus.common.block.entity.EssenceUtremJarBlockEntity;
import com.stal111.forbidden_arcanus.common.block.entity.forge.essence.EssenceType;
import com.stal111.forbidden_arcanus.common.block.properties.ModBlockStateProperties;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;

public class JarFlyingLabel
implements BlockFlyingLabel {
    private static final String ESSENCE_FORMAT = "tooltip.forbidden_arcanus.essence.storage_format";
    private static final int ICON_SIZE = 12;

    @Override
    public void render(GuiGraphics guiGraphics, ItemStack stack, DeltaTracker deltaTracker, int centerX, int centerY, BlockHitResult result) {
        PoseStack poseStack = guiGraphics.pose();
        ClientLevel level = Minecraft.getInstance().level;
        BlockPos pos = result.getBlockPos();
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof EssenceUtremJarBlockEntity) {
            EssenceUtremJarBlockEntity blockEntity2 = (EssenceUtremJarBlockEntity)blockEntity;
            EssenceType type = (EssenceType)((Object)level.getBlockState(pos).getValue(ModBlockStateProperties.ESSENCE_TYPE));
            poseStack.pushPose();
            MutableComponent component = Component.translatable((String)ESSENCE_FORMAT, (Object[])new Object[]{blockEntity2.getAmount(), blockEntity2.getLimit()});
            int width = Minecraft.getInstance().font.width(component.getVisualOrderText()) + 12 + 3;
            guiGraphics.fill(centerX - width / 2 - 2, centerY - 20 - 3, centerX + width / 2 + 2, centerY - 10 + 2, 0x44000000);
            guiGraphics.fill(centerX - width / 2 - 4, centerY - 20 - 5, centerX + width / 2 + 4, centerY - 10 + 4, 0x44000000);
            guiGraphics.blitSprite(type.getSpriteLocation(), centerX - width / 2, centerY - 20 - 2, 12, 12);
            guiGraphics.drawString(Minecraft.getInstance().font, component.getVisualOrderText(), centerX - width / 2 + 12 + 2, centerY - 20, -1);
            poseStack.popPose();
        }
    }
}

