/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.stal111.forbidden_arcanus.client.model.MagicCircleModel;
import com.stal111.forbidden_arcanus.common.block.entity.forge.HephaestusForgeBlockEntity;
import com.stal111.forbidden_arcanus.common.block.entity.forge.MagicCircle;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class HephaestusForgeRenderer
implements BlockEntityRenderer<HephaestusForgeBlockEntity> {
    private final MagicCircleModel magicCircleModel;

    public HephaestusForgeRenderer(BlockEntityRendererProvider.Context context) {
        this.magicCircleModel = new MagicCircleModel(context);
    }

    public void render(@Nonnull HephaestusForgeBlockEntity blockEntity, float partialTicks, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        ItemStack stack;
        MagicCircle magicCircle = blockEntity.getMagicCircleController().getMagicCircle();
        if (magicCircle != null) {
            magicCircle.render(poseStack, partialTicks, bufferSource, packedLight, this.magicCircleModel, blockEntity.getClientRitualDuration());
        }
        if (blockEntity.hasValidRitualIndicator()) {
            blockEntity.getValidRitualIndicator().render(poseStack, partialTicks, bufferSource, packedLight, this.magicCircleModel.validRitualIndicator());
        }
        if (!(stack = blockEntity.getClientMainItem()).isEmpty()) {
            poseStack.pushPose();
            poseStack.translate(0.5, 1.3, 0.5);
            poseStack.mulPose(Axis.YP.rotation(((float)blockEntity.getDisplayCounter() + partialTicks) / 20.0f));
            poseStack.scale(0.5f, 0.5f, 0.5f);
            Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, bufferSource, blockEntity.getLevel(), 0);
            poseStack.popPose();
        }
    }

    public boolean shouldRenderOffScreen(@Nonnull HephaestusForgeBlockEntity blockEntity) {
        return this.useExpandedRenderBoundingBox(blockEntity);
    }

    @NotNull
    public AABB getRenderBoundingBox(@NotNull HephaestusForgeBlockEntity blockEntity) {
        AABB boundingBox = super.getRenderBoundingBox((BlockEntity)blockEntity).expandTowards(0.0, 1.0, 0.0);
        if (this.useExpandedRenderBoundingBox(blockEntity)) {
            boundingBox = boundingBox.inflate(2.5, 0.0, 2.5);
        }
        return boundingBox;
    }

    public boolean useExpandedRenderBoundingBox(HephaestusForgeBlockEntity blockEntity) {
        return blockEntity.getRitualManager().isRitualActive() || blockEntity.hasValidRitualIndicator();
    }
}

