/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.block.clibano;

import com.stal111.forbidden_arcanus.common.block.entity.clibano.ClibanoFrameBlockEntity;
import com.stal111.forbidden_arcanus.common.block.entity.clibano.ClibanoMainBlockEntity;
import com.stal111.forbidden_arcanus.core.init.ModBlockEntities;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Containers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class ClibanoMainPartBlock
extends Block
implements EntityBlock {
    public ClibanoMainPartBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Nullable
    public BlockEntity newBlockEntity(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new ClibanoMainBlockEntity(pos, state);
    }

    @Nonnull
    public RenderShape getRenderShape(@Nonnull BlockState state) {
        return RenderShape.INVISIBLE;
    }

    public void onRemove(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        ServerLevel serverLevel;
        BlockEntity blockEntity;
        if (state.is(newState.getBlock())) {
            return;
        }
        if (level instanceof ServerLevel && (blockEntity = (serverLevel = (ServerLevel)level).getBlockEntity(pos)) instanceof ClibanoMainBlockEntity) {
            ClibanoMainBlockEntity blockEntity2 = (ClibanoMainBlockEntity)blockEntity;
            Containers.dropContents((Level)level, (BlockPos)pos, (NonNullList)blockEntity2.getStacks());
            blockEntity2.getRecipesToAwardAndPopExperience(serverLevel, Vec3.atCenterOf((Vec3i)pos));
            super.onRemove(state, level, pos, newState, isMoving);
        }
        ClibanoMainPartBlock.dismantle(level, pos);
    }

    public static void dismantle(Level level, BlockPos mainPos) {
        Iterable positions = BlockPos.betweenClosed((BlockPos)mainPos.offset(-1, -1, -1), (BlockPos)mainPos.offset(1, 1, 1));
        for (BlockPos pos : positions) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (!(blockEntity instanceof ClibanoFrameBlockEntity)) continue;
            ClibanoFrameBlockEntity blockEntity2 = (ClibanoFrameBlockEntity)blockEntity;
            if (level.getBlockState(pos).isAir()) continue;
            level.levelEvent(2001, pos, Block.getId((BlockState)level.getBlockState(pos)));
            level.setBlockAndUpdate(pos, blockEntity2.getFrameData().replaceState());
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@Nonnull Level level, @Nonnull BlockState state, @Nonnull BlockEntityType<T> blockEntityType) {
        if (level.isClientSide()) {
            return null;
        }
        return BaseEntityBlock.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntities.CLIBANO_MAIN.get()), ClibanoMainBlockEntity::serverTick);
    }
}

