/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.block.entity;

import com.stal111.forbidden_arcanus.common.block.pedestal.effect.PedestalEffectTrigger;
import com.stal111.forbidden_arcanus.core.init.ModBlockEntities;
import com.stal111.forbidden_arcanus.core.init.ModSounds;
import com.stal111.forbidden_arcanus.core.registry.FARegistries;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PedestalBlockEntity
extends BlockEntity {
    public static final int DEFAULT_ITEM_HEIGHT = 120;
    private ItemStack stack = ItemStack.EMPTY;
    private final float hoverStart = (float)(Math.random() * Math.PI * 2.0);
    private int ticksExisted;
    private int itemHeight = 120;
    private int heightTarget = 120;

    public PedestalBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.PEDESTAL.get(), pos, state);
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, PedestalBlockEntity blockEntity) {
        ++blockEntity.ticksExisted;
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, PedestalBlockEntity blockEntity) {
        if (blockEntity.itemHeight != blockEntity.heightTarget) {
            blockEntity.itemHeight = blockEntity.itemHeight < blockEntity.heightTarget ? ++blockEntity.itemHeight : --blockEntity.itemHeight;
            blockEntity.markUpdated();
        }
    }

    public void onLoad() {
        super.onLoad();
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            FARegistries.PEDESTAL_EFFECT_REGISTRY.stream().filter(pedestalEffect -> pedestalEffect.shouldExecute(PedestalEffectTrigger.LOAD)).forEach(pedestalEffect -> pedestalEffect.execute(serverLevel, this.getBlockPos(), this.stack));
        }
    }

    public void setStack(ItemStack stack, @Nullable Player player, PedestalEffectTrigger trigger) {
        this.stack = stack;
        this.markUpdated();
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.gameEvent((Holder)GameEvent.BLOCK_CHANGE, this.getBlockPos(), GameEvent.Context.of((Entity)player, (BlockState)this.getBlockState()));
            FARegistries.PEDESTAL_EFFECT_REGISTRY.stream().filter(pedestalEffect -> pedestalEffect.shouldExecute(trigger)).forEach(pedestalEffect -> pedestalEffect.execute(serverLevel, this.getBlockPos(), stack));
            this.level.playSound(null, this.getBlockPos(), (SoundEvent)ModSounds.PEDESTAL_INTERACT.get(), SoundSource.BLOCKS, 0.8f, this.level.getRandom().nextFloat() * 0.15f + 0.9f - (stack.isEmpty() ? 0.3f : 0.0f));
        }
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public boolean hasStack() {
        return !this.stack.isEmpty();
    }

    public void clearStack(@Nullable Player player, PedestalEffectTrigger trigger) {
        this.itemHeight = 120;
        this.setStack(ItemStack.EMPTY, player, trigger);
    }

    public float getItemHover(float partialTicks) {
        return ((float)this.ticksExisted + partialTicks) / 20.0f + this.hoverStart;
    }

    public int getItemHeight() {
        return this.itemHeight;
    }

    public void setItemHeightTarget(int heightTarget) {
        this.heightTarget = heightTarget;
    }

    protected void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookupProvider) {
        super.loadAdditional(tag, lookupProvider);
        this.stack = tag.contains("Stack", 10) ? ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)tag.getCompound("Stack")) : ItemStack.EMPTY;
        this.itemHeight = tag.getInt("ItemHeight");
    }

    public void saveAdditional(@Nonnull CompoundTag compound, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookupProvider) {
        super.saveAdditional(compound, lookupProvider);
        if (!this.stack.isEmpty()) {
            compound.put("Stack", this.stack.save(lookupProvider));
        }
        compound.putInt("ItemHeight", this.itemHeight);
    }

    private void markUpdated() {
        this.setChanged();
        this.getLevel().sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookupProvider) {
        return this.saveWithoutMetadata(lookupProvider);
    }
}

