/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.block.entity.forge.essence;

import com.mojang.serialization.DynamicOps;
import com.stal111.forbidden_arcanus.common.block.entity.forge.essence.EssenceType;
import com.stal111.forbidden_arcanus.common.block.entity.forge.essence.EssencesDefinition;
import com.stal111.forbidden_arcanus.common.block.entity.forge.essence.EssencesStorage;
import it.unimi.dsi.fastutil.objects.Object2FloatArrayMap;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.valhelsia.valhelsia_core.api.common.util.SerializableComponent;

public class EssenceManager
implements SerializableComponent {
    public static final String TAG_ESSENCES = "essences";
    private static final int ENTITY_CHECK_RADIUS = 5;
    private final EssencesStorage essences = new EssencesStorage();
    private final Object2FloatArrayMap<LivingEntity> cachedHealth = new Object2FloatArrayMap();
    private EssencesDefinition maxEssences;
    private final Consumer<EssencesDefinition> onChanged;

    public EssenceManager(EssencesDefinition maxEssences, Consumer<EssencesDefinition> onChanged) {
        this.maxEssences = maxEssences;
        this.onChanged = onChanged;
    }

    public void setMaxEssences(EssencesDefinition maxEssences) {
        this.maxEssences = maxEssences;
    }

    public EssencesStorage getStorage() {
        return this.essences;
    }

    public EssencesDefinition getCurrentEssences() {
        return this.getStorage().immutable();
    }

    public int getEssence(EssenceType type) {
        return this.essences.getOrDefault((Object)type, 0);
    }

    public void setEssence(EssenceType type, int value) {
        this.setEssence(type, value, true);
    }

    public void setEssence(EssenceType type, int value, boolean changed) {
        this.essences.put(type, value);
        if (changed) {
            this.onChanged.accept(this.essences.immutable());
        }
    }

    public void increaseEssence(EssenceType type, int amount) {
        this.setEssence(type, Math.min(this.maxEssences.get(type), this.getEssence(type) + amount));
    }

    public int getAureal() {
        return this.getEssence(EssenceType.AUREAL);
    }

    public void setAureal(int aureal) {
        this.setEssence(EssenceType.AUREAL, aureal);
    }

    public int getSouls() {
        return this.getEssence(EssenceType.SOULS);
    }

    public void setSouls(int souls) {
        this.setEssence(EssenceType.SOULS, souls);
    }

    public int getBlood() {
        return this.getEssence(EssenceType.BLOOD);
    }

    public void setBlood(int blood) {
        this.setEssence(EssenceType.BLOOD, blood);
    }

    public int getExperience() {
        return this.getEssence(EssenceType.EXPERIENCE);
    }

    public void setExperience(int experience) {
        this.setEssence(EssenceType.EXPERIENCE, experience);
    }

    public boolean isEssenceFull(EssenceType type) {
        return this.getEssence(type) >= this.maxEssences.get(type);
    }

    public CompoundTag save(CompoundTag tag) {
        EssencesStorage.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.essences).result().ifPresent(essences -> tag.put(TAG_ESSENCES, essences));
        return tag;
    }

    public void load(CompoundTag tag) {
        EssencesStorage.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get(TAG_ESSENCES)).result().ifPresent(essences -> {
            this.essences.clear();
            this.essences.putAll(essences);
        });
    }

    public void tick(Level level, BlockPos pos) {
        List entities = level.getEntitiesOfClass(LivingEntity.class, new AABB(pos).inflate(5.0));
        for (LivingEntity entity : entities) {
            float healthDifference;
            if (!this.cachedHealth.containsKey((Object)entity) || !((healthDifference = this.cachedHealth.getFloat((Object)entity) - entity.getHealth()) > 0.0f)) continue;
            this.increaseEssence(EssenceType.BLOOD, (int)healthDifference * 20);
        }
        this.cachedHealth.clear();
        for (LivingEntity entity : entities) {
            this.cachedHealth.put((Object)entity, entity.getHealth());
        }
    }
}

