/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.block.entity.forge.ritual;

import com.mojang.serialization.DynamicOps;
import com.stal111.forbidden_arcanus.common.block.entity.PedestalBlockEntity;
import com.stal111.forbidden_arcanus.common.block.entity.forge.ForgeDataCache;
import com.stal111.forbidden_arcanus.common.block.entity.forge.circle.MagicCircleController;
import com.stal111.forbidden_arcanus.common.block.entity.forge.essence.EssenceModifier;
import com.stal111.forbidden_arcanus.common.block.entity.forge.essence.EssencesDefinition;
import com.stal111.forbidden_arcanus.common.block.entity.forge.essence.EssencesStorage;
import com.stal111.forbidden_arcanus.common.block.entity.forge.ritual.ActiveRitualData;
import com.stal111.forbidden_arcanus.common.block.entity.forge.ritual.Ritual;
import com.stal111.forbidden_arcanus.common.block.pedestal.effect.PedestalEffectTrigger;
import com.stal111.forbidden_arcanus.common.entity.CrimsonLightningBoltEntity;
import com.stal111.forbidden_arcanus.common.item.enhancer.EnhancerDefinition;
import com.stal111.forbidden_arcanus.common.item.enhancer.EnhancerTarget;
import com.stal111.forbidden_arcanus.common.network.clientbound.AdvancedBlockEventPayload;
import com.stal111.forbidden_arcanus.core.init.ModEntities;
import com.stal111.forbidden_arcanus.core.init.ModParticles;
import com.stal111.forbidden_arcanus.core.registry.FARegistries;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.commons.lang3.BooleanUtils;
import org.jetbrains.annotations.Nullable;

public class RitualManager {
    public static final String TAG_ACTIVE_RITUAL = "active_ritual";
    public static final int PEDESTAL_ITEM_HEIGHT = 140;
    public static final int LIGHTNING_COUNTER_THRESHOLD = 300;
    private final MagicCircleController magicCircleController;
    private ForgeDataCache dataCache;
    private ServerLevel level;
    private BlockPos pos;
    private int forgeTier;
    @Nullable
    private Holder<Ritual> validRitual;
    @Nullable
    private ActiveRitualData activeRitualData;

    public RitualManager(MagicCircleController circleController, int forgeTier, ForgeDataCache dataCache) {
        this.magicCircleController = circleController;
        this.forgeTier = forgeTier;
        this.dataCache = dataCache;
    }

    public void setup(ServerLevel level, BlockPos pos) {
        this.level = level;
        this.pos = pos;
    }

    public void setForgeTier(int forgeTier) {
        this.forgeTier = forgeTier;
    }

    public Optional<Holder<Ritual>> getValidRitual() {
        return Optional.ofNullable(this.validRitual);
    }

    private Optional<ActiveRitualData> getActiveRitualData() {
        return Optional.ofNullable(this.activeRitualData);
    }

    private void setActiveRitual(@Nullable Holder<Ritual> ritual) {
        this.activeRitualData = ritual != null ? ActiveRitualData.create(ritual) : null;
        int duration = ritual != null ? ((Ritual)ritual.value()).duration() : 0;
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)this.level, (ChunkPos)new ChunkPos(this.pos), (CustomPacketPayload)new AdvancedBlockEventPayload(this.pos, this.level.getBlockState(this.pos).getBlock(), 3, duration), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public boolean isRitualActive() {
        return this.level != null && this.getActiveRitualData().isPresent();
    }

    public void onDataChanged(ForgeDataCache dataCache, EssencesDefinition essencesDefinition, HolderLookup.Provider lookupProvider) {
        this.dataCache = dataCache;
        this.getActiveRitualData().ifPresent(data -> {
            if (!data.getRitual().checkIngredients(this.dataCache.getIngredients(), this.dataCache.mainIngredient())) {
                this.failRitual();
            }
        });
        this.updateValidRitual(essencesDefinition, lookupProvider);
    }

    public void updateValidRitual(EssencesDefinition definition, HolderLookup.Provider lookupProvider) {
        boolean oldValue = this.validRitual != null;
        for (Holder ritual : lookupProvider.lookupOrThrow(FARegistries.RITUAL).listElements().toList()) {
            if (!this.canStartRitual((Ritual)ritual.value(), definition)) continue;
            if (!oldValue) {
                this.updateRitualIndicator(true);
            }
            this.validRitual = ritual;
            return;
        }
        this.validRitual = null;
        if (oldValue && !this.isRitualActive()) {
            this.updateRitualIndicator(false);
        }
    }

    private boolean canStartRitual(Ritual ritual, EssencesDefinition definition) {
        List<EssenceModifier> modifiers = this.dataCache.getEnhancers().stream().flatMap(enhancerDefinition -> ((EnhancerDefinition)enhancerDefinition.value()).getEffects(EnhancerTarget.HEPHAESTUS_FORGE)).filter(effect -> effect instanceof EssenceModifier).map(effect -> (EssenceModifier)((Object)effect)).toList();
        EssencesDefinition updatedEssences = ritual.requirements().essences().applyModifiers(modifiers);
        return definition.hasMoreThan(updatedEssences) && ritual.canStart(this.dataCache, this.forgeTier);
    }

    public boolean startRitual(EssencesStorage storage) {
        return this.getValidRitual().map(ritual -> {
            this.setActiveRitual((Holder<Ritual>)ritual);
            this.magicCircleController.createMagicCircle(this.level, this.pos, ((Ritual)ritual.value()).magicCircleType());
            storage.reduce(((Ritual)ritual.value()).requirements().essences());
            this.forEachPedestal(PedestalBlockEntity::hasStack, blockEntity -> blockEntity.setItemHeightTarget(140));
            return true;
        }).orElse(false);
    }

    public Optional<ItemStack> tick() {
        ActiveRitualData data = this.getActiveRitualData().orElse(null);
        if (data == null) {
            return Optional.empty();
        }
        RandomSource random = this.level.getRandom();
        float progress = data.calculateRitualProgress();
        data.incrementCounter();
        this.handleLightningCounter(data);
        this.dataCache.cachedIngredients().forEach(entry -> this.addItemParticles(entry.pos(), Math.min(120 + data.getCounter(), 140), entry.stack()));
        if (progress == 0.5f && random.nextDouble() <= this.getFailureChance() * 2.0) {
            CrimsonLightningBoltEntity entity = new CrimsonLightningBoltEntity((EntityType<? extends LightningBolt>)((EntityType)ModEntities.CRIMSON_LIGHTNING_BOLT.get()), (Level)this.level);
            entity.setPos((double)this.pos.getX() + 0.5, (double)this.pos.getY() + 1.0, (double)this.pos.getZ() + 0.5);
            entity.setVisualOnly(true);
            this.level.addFreshEntity((Entity)entity);
            data.incrementLightningCounter();
            this.forEachPedestal(PedestalBlockEntity::hasStack, pedestalBlockEntity -> {
                if (random.nextBoolean()) {
                    ItemStack stack = pedestalBlockEntity.getStack().copy();
                    BlockPos pedestalPos = pedestalBlockEntity.getBlockPos();
                    this.level.addFreshEntity((Entity)new ItemEntity((Level)this.level, (double)pedestalPos.getX() + 0.5, (double)((float)pedestalPos.getY() + (float)pedestalBlockEntity.getItemHeight() / 100.0f), (double)pedestalPos.getZ() + 0.5, stack));
                    pedestalBlockEntity.clearStack(null, PedestalEffectTrigger.RITUAL_FINISHED);
                }
            });
        }
        if (progress == 1.0f) {
            if (random.nextDouble() > this.getFailureChance()) {
                return Optional.of(this.finishRitual(data));
            }
            return Optional.of(this.failRitual());
        }
        return Optional.empty();
    }

    private void handleLightningCounter(ActiveRitualData data) {
        if (data.getLightningCounter() != 0) {
            data.incrementLightningCounter();
            if (data.getLightningCounter() == 300) {
                ArrayList<ItemStack> list = new ArrayList<ItemStack>();
                this.forEachPedestal(PedestalBlockEntity::hasStack, pedestalBlockEntity -> list.add(pedestalBlockEntity.getStack()));
                if (!data.getRitual().checkIngredients(list, this.dataCache.mainIngredient())) {
                    this.failRitual();
                }
            }
        }
    }

    private ItemStack finishRitual(ActiveRitualData data) {
        this.reset();
        return data.getRitual().result().apply((Level)this.level, this.pos, this.forgeTier);
    }

    private ItemStack failRitual() {
        ItemStack stack = this.dataCache.mainIngredient();
        this.reset();
        if (!stack.isEmpty()) {
            this.level.addFreshEntity((Entity)new ItemEntity((Level)this.level, (double)this.pos.getX() + 0.5, (double)(this.pos.getY() + 1), (double)this.pos.getZ() + 0.5, stack));
        }
        this.level.sendParticles((ParticleOptions)((SimpleParticleType)ModParticles.HUGE_MAGIC_EXPLOSION.get()), (double)this.pos.getX() + 0.5, (double)this.pos.getY() + 0.5, (double)this.pos.getZ() + 0.5, 0, 1.0, 0.0, 0.0, 0.0);
        this.level.playSound(null, (double)this.pos.getX() + 0.5, (double)this.pos.getY() + 0.5, (double)this.pos.getZ() + 0.5, (SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), SoundSource.BLOCKS, 4.0f, (1.0f + (this.level.getRandom().nextFloat() - this.level.getRandom().nextFloat()) * 0.2f) * 0.7f);
        return ItemStack.EMPTY;
    }

    private void clearPedestals() {
        this.forEachPedestal(PedestalBlockEntity::hasStack, blockEntity -> blockEntity.clearStack(null, PedestalEffectTrigger.RITUAL_FINISHED));
        this.dataCache.cachedIngredients().clear();
    }

    private void addItemParticles(BlockPos pedestalPos, int itemHeight, ItemStack stack) {
        double posX = (double)pedestalPos.getX() + 0.5;
        double posY = (double)pedestalPos.getY() + 0.1 + (double)((float)itemHeight / 100.0f);
        double posZ = (double)pedestalPos.getZ() + 0.5;
        double xSpeed = 0.1 * (double)(this.pos.getX() - pedestalPos.getX());
        double ySpeed = 0.22;
        double zSpeed = 0.1 * (double)(this.pos.getZ() - pedestalPos.getZ());
        if (this.level.getRandom().nextDouble() < 0.6) {
            this.level.sendParticles((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, stack), posX, posY, posZ, 0, xSpeed, ySpeed, zSpeed, 0.9);
        }
    }

    private void reset() {
        this.validRitual = null;
        this.setActiveRitual(null);
        this.magicCircleController.removeMagicCircle(this.level, this.pos);
        this.updateRitualIndicator(false);
        this.clearPedestals();
    }

    private double getFailureChance() {
        return 0.0;
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        this.getActiveRitualData().flatMap(data -> ActiveRitualData.CODEC.encodeStart((DynamicOps)RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)lookupProvider), (Object)this.activeRitualData).result()).ifPresent(dataTag -> tag.put(TAG_ACTIVE_RITUAL, dataTag));
        return tag;
    }

    public void load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        if (tag.contains(TAG_ACTIVE_RITUAL)) {
            this.activeRitualData = ActiveRitualData.CODEC.parse((DynamicOps)RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)lookupProvider), (Object)tag.get(TAG_ACTIVE_RITUAL)).resultOrPartial(System.err::println).orElse(null);
        }
    }

    private void forEachPedestal(Predicate<PedestalBlockEntity> predicate, Consumer<PedestalBlockEntity> consumer) {
        for (ForgeDataCache.IngredientEntry entry : this.dataCache.cachedIngredients()) {
            PedestalBlockEntity blockEntity;
            BlockEntity blockEntity2 = this.level.getBlockEntity(entry.pos());
            if (!(blockEntity2 instanceof PedestalBlockEntity) || !predicate.test(blockEntity = (PedestalBlockEntity)blockEntity2)) continue;
            consumer.accept(blockEntity);
        }
    }

    private void updateRitualIndicator(boolean show) {
        if (this.level != null) {
            this.level.blockEvent(this.pos, this.level.getBlockState(this.pos).getBlock(), 1, BooleanUtils.toInteger((boolean)show));
        }
    }
}

