/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.entity.projectile;

import com.stal111.forbidden_arcanus.common.aureal.AurealHelper;
import com.stal111.forbidden_arcanus.common.block.entity.forge.essence.EssenceType;
import com.stal111.forbidden_arcanus.common.entity.lostsoul.AbstractLostSoul;
import com.stal111.forbidden_arcanus.common.essence.EssenceHelper;
import com.stal111.forbidden_arcanus.common.network.clientbound.SpawnParticlePayload;
import com.stal111.forbidden_arcanus.core.init.ModEntities;
import com.stal111.forbidden_arcanus.core.init.ModItems;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.network.PacketDistributor;

public class ThrownAurealBottle
extends ThrowableItemProjectile {
    public ThrownAurealBottle(EntityType<? extends ThrownAurealBottle> entityType, Level level) {
        super(entityType, level);
    }

    public ThrownAurealBottle(Level level, LivingEntity shooter) {
        super((EntityType)ModEntities.AUREAL_BOTTLE.get(), shooter, level);
    }

    protected double getDefaultGravity() {
        return 0.055f;
    }

    @Nonnull
    protected Item getDefaultItem() {
        return (Item)ModItems.SPLASH_AUREAL_BOTTLE.get();
    }

    protected void onHit(@Nonnull HitResult result) {
        super.onHit(result);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.applySplash();
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)serverLevel, (ChunkPos)new ChunkPos(this.blockPosition()), (CustomPacketPayload)new SpawnParticlePayload(this.getX(), this.getY(), this.getZ(), 1), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.discard();
        }
    }

    private void applySplash() {
        AABB aabb = this.getBoundingBox().inflate(4.0, 2.0, 4.0);
        List list = this.level().getEntitiesOfClass(LivingEntity.class, aabb);
        if (list.isEmpty()) {
            return;
        }
        for (LivingEntity entity : list) {
            double distance = this.distanceToSqr((Entity)entity);
            if (!(distance < 16.0)) continue;
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                EssenceHelper.getEssenceProvider((LivingEntity)player).ifPresent(provider -> provider.updateAmount(EssenceType.AUREAL, amount -> amount + 30));
            }
            if (AurealHelper.canEntityBeAureal(entity) && !entity.getPersistentData().getBoolean("aureal")) {
                entity.getPersistentData().putBoolean("aureal", true);
            }
            if (!(entity instanceof AbstractLostSoul)) continue;
            AbstractLostSoul lostSoul = (AbstractLostSoul)entity;
            if (lostSoul.getType() == ModEntities.CORRUPT_LOST_SOUL.get()) {
                lostSoul.convertTo((EntityType)ModEntities.LOST_SOUL.get(), true);
                continue;
            }
            if (lostSoul.getType() != ModEntities.LOST_SOUL.get()) continue;
            lostSoul.convertTo((EntityType)ModEntities.ENCHANTED_LOST_SOUL.get(), true);
        }
    }
}

