/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.integration;

import com.stal111.forbidden_arcanus.ForbiddenArcanus;
import com.stal111.forbidden_arcanus.client.gui.screen.research.ResearchScreen;
import com.stal111.forbidden_arcanus.common.block.entity.forge.ritual.Ritual;
import com.stal111.forbidden_arcanus.common.block.entity.forge.ritual.result.CreateItemResult;
import com.stal111.forbidden_arcanus.common.block.entity.forge.ritual.result.UpgradeTierResult;
import com.stal111.forbidden_arcanus.common.integration.ApplyModifierRecipeMaker;
import com.stal111.forbidden_arcanus.common.integration.ClibanoCombustionCategory;
import com.stal111.forbidden_arcanus.common.integration.hephaestus_forge.SmithingCategory;
import com.stal111.forbidden_arcanus.common.integration.hephaestus_forge.UpgradeTierCategory;
import com.stal111.forbidden_arcanus.common.item.crafting.ClibanoRecipe;
import com.stal111.forbidden_arcanus.core.init.ModBlocks;
import com.stal111.forbidden_arcanus.core.init.ModRecipeTypes;
import com.stal111.forbidden_arcanus.core.registry.FARegistries;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class ForbiddenArcanusJEIPlugin
implements IModPlugin {
    public IRecipeCategory<?> hephaestusSmithing;
    public IRecipeCategory<?> hephaestusForgeUpgrading;
    public IRecipeCategory<?> clibanoCombustion;
    public static final RecipeType<Ritual> HEPHAESTUS_SMITHING = RecipeType.create((String)"forbidden_arcanus", (String)"hephaestus_smithing", Ritual.class);
    public static final RecipeType<Ritual> HEPHAESTUS_FORGE_UPGRADING = RecipeType.create((String)"forbidden_arcanus", (String)"hephaestus_forge_upgrading", Ritual.class);
    public static final RecipeType<ClibanoRecipe> CLIBANO_COMBUSTION = RecipeType.create((String)"forbidden_arcanus", (String)"clibano_combustion", ClibanoRecipe.class);

    @NotNull
    public ResourceLocation getPluginUid() {
        return ForbiddenArcanus.location("main");
    }

    public void registerGuiHandlers(@NotNull IGuiHandlerRegistration registration) {
        registration.addGuiScreenHandler(ResearchScreen.class, guiScreen -> null);
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ClientLevel level = Minecraft.getInstance().level;
        registration.addRecipes(RecipeTypes.SMITHING, ApplyModifierRecipeMaker.getRecipes());
        Registry registry = level.registryAccess().registryOrThrow(FARegistries.RITUAL);
        registration.addRecipes(HEPHAESTUS_SMITHING, registry.stream().filter(ritual -> ritual.result() instanceof CreateItemResult).toList());
        registration.addRecipes(HEPHAESTUS_FORGE_UPGRADING, registry.stream().filter(ritual -> ritual.result() instanceof UpgradeTierResult).toList());
        registration.addRecipes(CLIBANO_COMBUSTION, level.getRecipeManager().getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)ModRecipeTypes.CLIBANO_COMBUSTION.get()).stream().map(RecipeHolder::value).toList());
    }

    public void registerRecipeCatalysts(@NotNull IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.HEPHAESTUS_FORGE_TIER_1.get()), new RecipeType[]{HEPHAESTUS_SMITHING, HEPHAESTUS_FORGE_UPGRADING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.CLIBANO_CORE.get()), new RecipeType[]{CLIBANO_COMBUSTION});
    }

    public void registerCategories(@NotNull IRecipeCategoryRegistration registration) {
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        IRecipeCategory[] iRecipeCategoryArray = new IRecipeCategory[3];
        this.hephaestusSmithing = new SmithingCategory(guiHelper);
        iRecipeCategoryArray[0] = this.hephaestusSmithing;
        this.hephaestusForgeUpgrading = new UpgradeTierCategory(guiHelper);
        iRecipeCategoryArray[1] = this.hephaestusForgeUpgrading;
        this.clibanoCombustion = new ClibanoCombustionCategory(guiHelper);
        iRecipeCategoryArray[2] = this.clibanoCombustion;
        registration.addRecipeCategories(iRecipeCategoryArray);
    }
}

