/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.stal111.forbidden_arcanus.ForbiddenArcanus;
import com.stal111.forbidden_arcanus.common.entity.projectile.EnergyBall;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.joml.Matrix4f;

public class EnergyBallRenderer
extends EntityRenderer<EnergyBall> {
    private static final ResourceLocation LOCATION = ForbiddenArcanus.location("textures/effect/energy_ball.png");

    public EnergyBallRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(@Nonnull EnergyBall entity, float entityYaw, float partialTicks, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource buffer, int packedLight) {
        poseStack.pushPose();
        VertexConsumer vertexConsumer = buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)this.getTextureLocation(entity)));
        Matrix4f matrix4f = poseStack.last().pose();
        long t = System.currentTimeMillis() % 6L;
        poseStack.mulPose(this.entityRenderDispatcher.cameraOrientation());
        vertexConsumer.addVertex(matrix4f, -1.0f, -1.0f, 0.0f).setColor(255, 255, 255, 255).setUv(0.0f, 0.0f + (float)t * 0.25f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(0.0f, 1.0f, 0.0f);
        vertexConsumer.addVertex(matrix4f, -1.0f, 1.0f, 0.0f).setColor(255, 255, 255, 255).setUv(0.0f, 0.0f + (float)t * 0.25f + 0.25f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(0.0f, 1.0f, 0.0f);
        vertexConsumer.addVertex(matrix4f, 1.0f, 1.0f, 0.0f).setColor(255, 255, 255, 255).setUv(1.0f, 0.0f + (float)t * 0.25f + 0.25f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(0.0f, 1.0f, 0.0f);
        vertexConsumer.addVertex(matrix4f, 1.0f, -1.0f, 0.0f).setColor(255, 255, 255, 255).setUv(1.0f, 0.0f + (float)t * 0.25f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(0.0f, 1.0f, 0.0f);
        poseStack.popPose();
        super.render((Entity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    @Nonnull
    public ResourceLocation getTextureLocation(@Nonnull EnergyBall entity) {
        return LOCATION;
    }
}

