/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.block.clibano;

import com.mojang.serialization.MapCodec;
import com.stal111.forbidden_arcanus.common.block.clibano.AbstractClibanoFrameBlock;
import com.stal111.forbidden_arcanus.common.block.entity.clibano.ClibanoFireType;
import com.stal111.forbidden_arcanus.common.block.properties.ModBlockStateProperties;
import com.stal111.forbidden_arcanus.common.block.properties.clibano.ClibanoCenterType;
import com.stal111.forbidden_arcanus.core.init.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class ClibanoCenterBlock
extends AbstractClibanoFrameBlock {
    public static final MapCodec<ClibanoCenterBlock> CODEC = ClibanoCenterBlock.simpleCodec(ClibanoCenterBlock::new);
    private static final EnumProperty<ClibanoCenterType> TYPE = ModBlockStateProperties.CLIBANO_CENTER_TYPE;

    public ClibanoCenterBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)this.getFacingProperty(), (Comparable)Direction.NORTH)).setValue(TYPE, (Comparable)((Object)ClibanoCenterType.SIDE)));
    }

    @Override
    public DirectionProperty getFacingProperty() {
        return BlockStateProperties.FACING;
    }

    @Override
    public BlockState updateAppearance(BlockState state, boolean isLit, ClibanoFireType fireType) {
        if (((ClibanoCenterType)((Object)state.getValue(TYPE))).isFront()) {
            return (BlockState)state.setValue(TYPE, (Comparable)((Object)(isLit ? ClibanoCenterType.valueOf("FRONT_" + String.valueOf((Object)fireType)) : ClibanoCenterType.FRONT_OFF)));
        }
        return super.updateAppearance(state, isLit, fireType);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)this.getFacingProperty(), (Comparable)context.getClickedFace());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{this.getFacingProperty(), TYPE});
    }

    public void animateTick(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        if (((ClibanoCenterType)((Object)state.getValue(TYPE))).getFireType() != null) {
            double x = (double)pos.getX() + 0.5;
            double y = pos.getY();
            double z = (double)pos.getZ() + 0.5;
            if (random.nextDouble() < 0.18) {
                SoundEvent soundEvent = state.getValue(TYPE) == ClibanoCenterType.FRONT_FIRE ? (SoundEvent)ModSounds.CLIBANO_FIRE_CRACKLE.get() : (SoundEvent)ModSounds.CLIBANO_SOUL_FIRE_CRACKLE.get();
                level.playLocalSound(x, y, z, soundEvent, SoundSource.BLOCKS, 0.2f, 1.0f, false);
            }
            Direction direction = (Direction)state.getValue((Property)this.getFacingProperty());
            Direction.Axis axis = direction.getAxis();
            double d4 = random.nextDouble() * 0.6 - 0.3;
            double d5 = axis == Direction.Axis.X ? (double)direction.getStepX() * 0.52 : d4;
            double d6 = random.nextDouble() * 9.0 / 16.0;
            double d7 = axis == Direction.Axis.Z ? (double)direction.getStepZ() * 0.52 : d4;
            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, x + d5, y + d6, z + d7, 0.0, 0.0, 0.0);
        }
    }
}

