/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.block.entity.forge;

import com.stal111.forbidden_arcanus.common.block.HephaestusForgeBlock;
import com.stal111.forbidden_arcanus.common.block.entity.forge.essence.EssenceType;
import com.stal111.forbidden_arcanus.common.block.entity.forge.essence.EssencesDefinition;
import com.stal111.forbidden_arcanus.core.init.ModBlocks;
import java.util.function.IntSupplier;
import net.valhelsia.valhelsia_core.api.common.registry.helper.block.BlockRegistryEntry;

public enum HephaestusForgeLevel implements IntSupplier
{
    ONE(ModBlocks.HEPHAESTUS_FORGE_TIER_1, 1000, 10, 10000, 900),
    TWO(ModBlocks.HEPHAESTUS_FORGE_TIER_2, 3000, 50, 15000, 1350),
    THREE(ModBlocks.HEPHAESTUS_FORGE_TIER_3, 5000, 100, 30000, 2500),
    FOUR(ModBlocks.HEPHAESTUS_FORGE_TIER_4, 10000, 500, 50000, 5000),
    FIVE(ModBlocks.HEPHAESTUS_FORGE_TIER_5, 20000, 1000, 100000, 7500);

    private final BlockRegistryEntry<HephaestusForgeBlock> block;
    private final EssencesDefinition maxEssences;

    private HephaestusForgeLevel(BlockRegistryEntry<HephaestusForgeBlock> block, int maxAureal, int maxSouls, int maxBlood, int maxExperience) {
        this.block = block;
        this.maxEssences = new EssencesDefinition(maxAureal, maxSouls, maxBlood, maxExperience);
    }

    public HephaestusForgeBlock getBlock() {
        return (HephaestusForgeBlock)((Object)this.block.get());
    }

    public int getMaxAmount(EssenceType type) {
        return this.maxEssences.get(type);
    }

    public int getMaxAureal() {
        return this.maxEssences.get(EssenceType.AUREAL);
    }

    public int getMaxSouls() {
        return this.maxEssences.get(EssenceType.SOULS);
    }

    public int getMaxBlood() {
        return this.maxEssences.get(EssenceType.BLOOD);
    }

    public int getMaxExperience() {
        return this.maxEssences.get(EssenceType.EXPERIENCE);
    }

    public EssencesDefinition getMaxEssences() {
        return this.maxEssences;
    }

    public static HephaestusForgeLevel getFromIndex(int index) {
        return switch (index) {
            case 1 -> ONE;
            case 2 -> TWO;
            case 3 -> THREE;
            case 4 -> FOUR;
            default -> FIVE;
        };
    }

    @Override
    public int getAsInt() {
        return this.ordinal() + 1;
    }
}

