/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.block.entity.forge.ritual.result;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stal111.forbidden_arcanus.common.block.HephaestusForgeBlock;
import com.stal111.forbidden_arcanus.common.block.entity.forge.ritual.result.RitualResult;
import com.stal111.forbidden_arcanus.common.block.entity.forge.ritual.result.RitualResultType;
import com.stal111.forbidden_arcanus.common.entity.CrimsonLightningBoltEntity;
import com.stal111.forbidden_arcanus.core.init.ModBlocks;
import com.stal111.forbidden_arcanus.core.init.ModEntities;
import com.stal111.forbidden_arcanus.core.init.ModRitualResultTypes;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.valhelsia.valhelsia_core.api.common.registry.helper.block.BlockRegistryEntry;

public record UpgradeTierResult(int resultTier) implements RitualResult
{
    private static final Map<Integer, BlockRegistryEntry<HephaestusForgeBlock>> FORGE_TIERS = ImmutableMap.of((Object)1, ModBlocks.HEPHAESTUS_FORGE_TIER_1, (Object)2, ModBlocks.HEPHAESTUS_FORGE_TIER_2, (Object)3, ModBlocks.HEPHAESTUS_FORGE_TIER_3, (Object)4, ModBlocks.HEPHAESTUS_FORGE_TIER_4, (Object)5, ModBlocks.HEPHAESTUS_FORGE_TIER_5);
    public static final MapCodec<UpgradeTierResult> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.intRange((int)1, (int)5).fieldOf("result_tier").forGetter(UpgradeTierResult::resultTier)).apply((Applicative)instance, UpgradeTierResult::new));

    @Override
    public ItemStack apply(Level level, BlockPos pos, int forgeTier) {
        BlockState state = level.getBlockState(pos);
        level.setBlockAndUpdate(pos, ((HephaestusForgeBlock)((Object)FORGE_TIERS.get(this.resultTier).get())).withPropertiesOf(state));
        CrimsonLightningBoltEntity entity = (CrimsonLightningBoltEntity)((EntityType)ModEntities.CRIMSON_LIGHTNING_BOLT.get()).create(level);
        if (entity != null) {
            entity.moveTo((double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5);
            entity.setVisualOnly(true);
            level.addFreshEntity((Entity)entity);
        }
        return ItemStack.EMPTY;
    }

    @Override
    public RitualResultType<? extends RitualResult> getType() {
        return (RitualResultType)ModRitualResultTypes.UPGRADE_TIER.get();
    }
}

