/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.item;

import com.stal111.forbidden_arcanus.common.block.entity.forge.essence.EssenceType;
import com.stal111.forbidden_arcanus.common.essence.EssenceHelper;
import javax.annotation.Nonnull;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.valhelsia.valhelsia_core.api.common.util.ItemStackUtils;

public class AurealBottleItem
extends Item {
    private static final int USE_DURATION = 32;

    public AurealBottleItem(Item.Properties properties) {
        super(properties);
    }

    @Nonnull
    public ItemStack finishUsingItem(@Nonnull ItemStack stack, @Nonnull Level level, @Nonnull LivingEntity livingEntity) {
        ItemStack emptyBottle = new ItemStack((ItemLike)Items.GLASS_BOTTLE);
        if (!(livingEntity instanceof Player)) {
            return emptyBottle;
        }
        Player player = (Player)livingEntity;
        if (player instanceof ServerPlayer) {
            CriteriaTriggers.CONSUME_ITEM.trigger((ServerPlayer)player, stack);
            EssenceHelper.getEssenceProvider((LivingEntity)player).ifPresent(provider -> provider.updateAmount(EssenceType.AUREAL, amount -> amount + 35));
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        ItemStackUtils.shrinkStack((Player)player, (ItemStack)stack);
        if (!player.getAbilities().instabuild) {
            if (stack.isEmpty()) {
                return emptyBottle;
            }
            player.getInventory().add(emptyBottle);
        }
        return stack;
    }

    public int getUseDuration(@Nonnull ItemStack stack, LivingEntity entity) {
        return 32;
    }

    @Nonnull
    public UseAnim getUseAnimation(@Nonnull ItemStack stack) {
        return UseAnim.DRINK;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(@Nonnull Level level, @Nonnull Player player, @Nonnull InteractionHand hand) {
        return EssenceHelper.getEssenceProvider((LivingEntity)player).map(provider -> {
            if (!provider.isFull(EssenceType.AUREAL)) {
                return ItemUtils.startUsingInstantly((Level)level, (Player)player, (InteractionHand)hand);
            }
            return super.use(level, player, hand);
        }).orElse(super.use(level, player, hand));
    }
}

