/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.item;

import com.stal111.forbidden_arcanus.common.entity.projectile.ThrownAurealBottle;
import javax.annotation.Nonnull;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.valhelsia.valhelsia_core.api.common.util.ItemStackUtils;

public class SplashAurealBottleItem
extends Item {
    public SplashAurealBottleItem(Item.Properties properties) {
        super(properties);
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(@Nonnull Level level, @Nonnull Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.EXPERIENCE_BOTTLE_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
        if (!level.isClientSide()) {
            ThrownAurealBottle bottle = new ThrownAurealBottle(level, (LivingEntity)player);
            bottle.setItem(stack);
            bottle.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), -20.0f, 0.7f, 1.0f);
            level.addFreshEntity((Entity)bottle);
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        ItemStackUtils.shrinkStack((Player)player, (ItemStack)stack);
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide());
    }
}

