/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.item.bucket;

import com.stal111.forbidden_arcanus.common.item.bucket.CapacityFluidBucket;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.NotNull;

public class CapacityBucketFluidHandler
implements IFluidHandlerItem {
    private final CapacityFluidBucket bucket;
    private ItemStack container;

    public CapacityBucketFluidHandler(CapacityFluidBucket bucket, ItemStack container) {
        this.bucket = bucket;
        this.container = container;
    }

    private int getFullness() {
        return this.bucket.getFullness(this.container);
    }

    private void setFluid(@NotNull FluidStack fluidStack) {
        Item item = this.bucket.getFilledBucket(fluidStack.getFluid());
        if (item != null) {
            this.container = new ItemStack((ItemLike)item);
        }
    }

    @NotNull
    public ItemStack getContainer() {
        return this.container;
    }

    public int getTanks() {
        return 1;
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        return new FluidStack(this.bucket.getFluid(), 1000 * this.getFullness());
    }

    public int getTankCapacity(int tank) {
        return this.bucket.getCapacity();
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        FluidStack fluidStack = this.getFluidInTank(tank);
        if (fluidStack.isEmpty()) {
            return this.bucket.getFilledBucket(stack.getFluid()) != null;
        }
        return FluidStack.isSameFluidSameComponents((FluidStack)stack, (FluidStack)fluidStack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.container.getCount() != 1 || resource.getAmount() < 1000 || this.bucket.isFull(this.container)) {
            return 0;
        }
        if (action.execute()) {
            int fullness = this.getFullness();
            if (this.container.is(this.bucket.getEmptyBucket())) {
                this.setFluid(resource);
                return 1000;
            }
            int fillAmount = Math.min(this.bucket.getCapacity() - fullness, resource.getAmount() / 1000);
            this.bucket.setFullness(this.container, fullness + fillAmount);
            return fillAmount * 1000;
        }
        return 0;
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.container.getCount() != 1 || resource.getAmount() < 1000 || !FluidStack.isSameFluidSameComponents((FluidStack)resource, (FluidStack)this.getFluidInTank(0))) {
            return FluidStack.EMPTY;
        }
        return this.drain(resource.getAmount(), action);
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (this.container.getCount() != 1 || maxDrain < 1000) {
            return FluidStack.EMPTY;
        }
        int fullness = this.getFullness();
        if (action.execute() && fullness != 0) {
            int drainAmount = Math.min(fullness, maxDrain / 1000);
            this.bucket.setFullness(this.container, fullness - drainAmount);
            if (fullness - drainAmount <= 0) {
                this.setFluid(FluidStack.EMPTY);
            }
            return new FluidStack(this.bucket.getFluid(), drainAmount * 1000);
        }
        return FluidStack.EMPTY;
    }
}

