/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.api.common.loot.condition;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.valhelsia.valhelsia_core.core.registry.ValhelsiaLootConditions;
import org.jetbrains.annotations.NotNull;

public record EntityTagCondition(TagKey<EntityType<?>> tag) implements LootItemCondition
{
    public static final MapCodec<EntityTagCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)TagKey.codec((ResourceKey)Registries.ENTITY_TYPE).fieldOf("tag").forGetter(condition -> condition.tag)).apply((Applicative)instance, EntityTagCondition::new));

    public static LootItemCondition.Builder builder(TagKey<EntityType<?>> tag) {
        return () -> new EntityTagCondition(tag);
    }

    @NotNull
    public LootItemConditionType getType() {
        return ValhelsiaLootConditions.ENTITY_TAG.get();
    }

    @NotNull
    public Set<LootContextParam<?>> getReferencedContextParams() {
        return ImmutableSet.of((Object)LootContextParams.THIS_ENTITY);
    }

    public boolean test(LootContext lootContext) {
        if (!lootContext.hasParam(LootContextParams.THIS_ENTITY)) {
            return false;
        }
        Entity entity = (Entity)lootContext.getParam(LootContextParams.THIS_ENTITY);
        return entity.getType().is(this.tag);
    }
}

