/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.datagen;

import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.valhelsia.valhelsia_core.api.common.registry.RegistryEntry;
import net.valhelsia.valhelsia_core.api.common.registry.RegistryManager;
import org.jetbrains.annotations.NotNull;

public abstract class ValhelsiaBlockLootTables
extends BlockLootSubProvider {
    public static final LootItemCondition.Builder HAS_SHEARS = MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of(new ItemLike[]{Items.SHEARS}));
    public static final float[] NORMAL_LEAVES_SAPLING_CHANCES = new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f};
    public static final float[] JUNGLE_LEAVES_SAPLING_CHANGES = new float[]{0.025f, 0.027777778f, 0.03125f, 0.041666668f, 0.1f};
    private final RegistryManager registryManager;

    public ValhelsiaBlockLootTables(Set<Item> explosionResistant, FeatureFlagSet flagSet, HolderLookup.Provider lookupProvider, RegistryManager registryManager) {
        super(explosionResistant, flagSet, lookupProvider);
        this.registryManager = registryManager;
    }

    public static Set<Item> immuneToExplosion() {
        return new HashSet<Item>();
    }

    protected static <T extends FunctionUserBuilder<T>> T withExplosionDecay(ItemLike item, FunctionUserBuilder<T> function) {
        return (T)(!ValhelsiaBlockLootTables.immuneToExplosion().contains(item.asItem()) ? function.apply((LootItemFunction.Builder)ApplyExplosionDecay.explosionDecay()) : function.unwrap());
    }

    protected static <T extends ConditionUserBuilder<T>> T withSurvivesExplosion(ItemLike item, ConditionUserBuilder<T> condition) {
        return (T)(!ValhelsiaBlockLootTables.immuneToExplosion().contains(item.asItem()) ? condition.when(ExplosionCondition.survivesExplosion()) : condition.unwrap());
    }

    protected static LootTable.Builder dropping(ItemLike item) {
        return LootTable.lootTable().withPool((LootPool.Builder)ValhelsiaBlockLootTables.withSurvivesExplosion(item, LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)item))));
    }

    protected static <T extends Comparable<T> & StringRepresentable> LootTable.Builder droppingWhen(Block block, Property<T> property, T value) {
        return LootTable.lootTable().withPool((LootPool.Builder)ValhelsiaBlockLootTables.withSurvivesExplosion((ItemLike)block, LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(LootItem.lootTableItem((ItemLike)block).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty(property, value))))));
    }

    protected void dropPottedContents(@NotNull Block flowerPot) {
        this.add(flowerPot, arg -> this.createPotFlowerItemTable((ItemLike)((FlowerPotBlock)arg).getPotted()));
    }

    protected static LootTable.Builder droppingWithFunction(Block block, Function<LootPoolSingletonContainer.Builder<?>, LootPoolSingletonContainer.Builder<?>> mapping) {
        return LootTable.lootTable().withPool((LootPool.Builder)ValhelsiaBlockLootTables.withSurvivesExplosion((ItemLike)block, LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)mapping.apply(LootItem.lootTableItem((ItemLike)block)))));
    }

    protected static LootTable.Builder droppingSlab(Block slab) {
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)ValhelsiaBlockLootTables.withExplosionDecay((ItemLike)slab, LootItem.lootTableItem((ItemLike)slab).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)2.0f)).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)slab).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)SlabBlock.TYPE, (Comparable)SlabType.DOUBLE)))))));
    }

    protected static LootTable.Builder registerDoor(Block door) {
        return ValhelsiaBlockLootTables.droppingWhen(door, DoorBlock.HALF, DoubleBlockHalf.LOWER);
    }

    protected static LootTable.Builder dropping(Block block, LootItemCondition.Builder conditionBuilder, LootPoolEntryContainer.Builder<?> lootEntryBuilder) {
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)block).when(conditionBuilder)).otherwise(lootEntryBuilder)));
    }

    protected void registerDropping(Block blockIn, ItemLike drop) {
        this.add(blockIn, ValhelsiaBlockLootTables.dropping(drop));
    }

    protected void registerDropSelfLootTable(Block block) {
        this.registerDropping(block, (ItemLike)block);
    }

    protected void add(Block blockIn, Function<Block, LootTable.Builder> factory) {
        this.add(blockIn, factory.apply(blockIn));
    }

    public LootPoolEntryContainer.Builder<?> setCountFromIntegerProperty(Block block, LootPoolSingletonContainer.Builder<?> lootEntryBuilder, IntegerProperty intProperty) {
        intProperty.getPossibleValues().forEach(integer -> lootEntryBuilder.apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)integer.intValue())).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)intProperty, integer.intValue())))));
        return lootEntryBuilder;
    }

    protected void generate() {
    }

    public void generate(@NotNull BiConsumer<ResourceKey<LootTable>, LootTable.Builder> biConsumer) {
        this.generate();
        HashSet<ResourceKey> set = new HashSet<ResourceKey>();
        for (RegistryEntry entry : this.registryManager.getBlockHelper().getRegistryEntries()) {
            ResourceKey resourceKey;
            if (!((Block)entry.get()).isEnabled(this.enabledFeatures) || (resourceKey = ((Block)entry.get()).getLootTable()) == BuiltInLootTables.EMPTY || !set.add(resourceKey)) continue;
            LootTable.Builder builder = (LootTable.Builder)this.map.remove(resourceKey);
            if (builder == null) {
                throw new IllegalStateException(String.format(Locale.ROOT, "Missing loottable '%s' for '%s'", resourceKey, BuiltInRegistries.BLOCK.getKey((Object)((Block)entry.get()))));
            }
            biConsumer.accept((ResourceKey<LootTable>)resourceKey, builder);
        }
        if (!this.map.isEmpty()) {
            throw new IllegalStateException("Created block loot tables for non-blocks: " + String.valueOf(this.map.keySet()));
        }
    }
}

