/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.api.common.counter.capability;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.valhelsia.valhelsia_core.api.common.counter.SerializableCounter;
import net.valhelsia.valhelsia_core.api.common.counter.capability.CounterCapability;
import net.valhelsia.valhelsia_core.api.common.counter.capability.CounterCreator;
import net.valhelsia.valhelsia_core.api.common.counter.capability.CounterImpl;
import org.apache.logging.log4j.LogManager;

public class CounterProvider
implements ICapabilityProvider,
ICapabilitySerializable<CompoundTag> {
    public static Capability<CounterCapability> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<CounterCapability>(){});
    private final CounterCapability instance = new CounterImpl();
    private final List<CounterCreator<? extends SerializableCounter>> counterCreators = new ArrayList<CounterCreator<? extends SerializableCounter>>();

    public CounterProvider(CounterCreator<? extends SerializableCounter> counterCreator) {
        this.instance.addCounter(counterCreator.create());
        this.counterCreators.add(counterCreator);
    }

    public CounterProvider(List<CounterCreator<? extends SerializableCounter>> counterCreators) {
        for (CounterCreator<? extends SerializableCounter> counterCreator : counterCreators) {
            this.instance.addCounter(counterCreator.create());
            this.counterCreators.add(counterCreator);
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return CAPABILITY.orEmpty(cap, LazyOptional.of(() -> this.instance));
    }

    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        for (SerializableCounter counter : this.instance.getCounters()) {
            compound.m_128365_(counter.m_7912_(), (Tag)counter.save(new CompoundTag()));
        }
        return compound;
    }

    public void deserializeNBT(CompoundTag nbt) {
        for (String name : nbt.m_128431_()) {
            ResourceLocation resourceLocation = new ResourceLocation(name);
            this.instance.removeCounter(this.instance.getCounter(resourceLocation));
            Optional<CounterCreator> optionalCounterCreator = this.counterCreators.stream().filter(counterCreator -> counterCreator.name().toString().equals(name)).findFirst();
            if (optionalCounterCreator.isEmpty()) {
                LogManager.getLogger().warn("No Counter found with name: " + name + ". Ignoring it.");
                continue;
            }
            Object counter = optionalCounterCreator.get().create();
            ((SerializableCounter)counter).load(nbt.m_128469_(name));
            this.instance.addCounter((SerializableCounter)counter);
        }
    }
}

