/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.api.datagen.recipes;

import com.google.errorprone.annotations.OverridingMethodsMustInvokeSuper;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.valhelsia.valhelsia_core.api.datagen.DataProviderContext;
import net.valhelsia.valhelsia_core.api.datagen.recipes.RecipeSubProvider;
import org.jetbrains.annotations.NotNull;

public class ValhelsiaRecipeProvider
extends RecipeProvider {
    @NotNull
    private Consumer<FinishedRecipe> finishedRecipeConsumer = finishedRecipe -> {};
    private final String modId;
    private final List<RecipeSubProvider> subProviders;

    @SafeVarargs
    public ValhelsiaRecipeProvider(DataProviderContext context, Function<ValhelsiaRecipeProvider, RecipeSubProvider> ... subProviders) {
        super(context.output());
        this.modId = context.registryManager().modId();
        this.subProviders = Arrays.stream(subProviders).map(function -> (RecipeSubProvider)function.apply(this)).toList();
    }

    @OverridingMethodsMustInvokeSuper
    protected void m_245200_(@NotNull Consumer<FinishedRecipe> consumer) {
        this.finishedRecipeConsumer = consumer;
        this.subProviders.forEach(RecipeSubProvider::registerRecipes);
    }

    @NotNull
    public Consumer<FinishedRecipe> getFinishedRecipeConsumer() {
        return this.finishedRecipeConsumer;
    }

    public String getModId() {
        return this.modId;
    }
}

