/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.integration.hephaestus_forge;

import com.stal111.forbidden_arcanus.common.block.HephaestusForgeBlock;
import com.stal111.forbidden_arcanus.common.block.entity.forge.ritual.Ritual;
import com.stal111.forbidden_arcanus.common.block.entity.forge.ritual.result.CreateItemResult;
import com.stal111.forbidden_arcanus.common.block.entity.forge.ritual.result.RitualResult;
import com.stal111.forbidden_arcanus.common.integration.ForbiddenArcanusJEIPlugin;
import com.stal111.forbidden_arcanus.common.integration.hephaestus_forge.HephaestusForgeCategory;
import com.stal111.forbidden_arcanus.core.init.ModBlocks;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class SmithingCategory
extends HephaestusForgeCategory {
    private static final String NAME = "hephaestus_smithing";
    private static final ResourceLocation TEXTURE = new ResourceLocation("forbidden_arcanus", "textures/gui/jei/hephaestus_forge/smithing.png");
    private static final IntIntPair FORGE_TIER_POSITION = IntIntPair.of((int)122, (int)85);
    private static final IntIntPair OUTPUT_POSITION = IntIntPair.of((int)122, (int)35);

    public SmithingCategory(IGuiHelper guiHelper) {
        super(NAME, guiHelper, TEXTURE, 41, 83);
    }

    @NotNull
    public RecipeType<Ritual> getRecipeType() {
        return ForbiddenArcanusJEIPlugin.HEPHAESTUS_SMITHING;
    }

    @Override
    protected void buildRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull Ritual ritual) {
        int requiredTier = ritual.requirements() == null ? 1 : ritual.requirements().tier();
        RitualResult ritualResult = ritual.result();
        if (ritualResult instanceof CreateItemResult) {
            CreateItemResult result = (CreateItemResult)ritualResult;
            builder.addSlot(RecipeIngredientRole.OUTPUT, OUTPUT_POSITION.firstInt(), OUTPUT_POSITION.secondInt()).addItemStack(result.getResult());
        }
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.RENDER_ONLY, FORGE_TIER_POSITION.firstInt(), FORGE_TIER_POSITION.secondInt()).addItemStack(HephaestusForgeBlock.setTierOnStack(new ItemStack((ItemLike)ModBlocks.HEPHAESTUS_FORGE.get()), requiredTier))).addTooltipCallback((recipeSlotView, tooltip) -> {
            tooltip.clear();
            tooltip.add(Component.m_237115_((String)"jei.forbidden_arcanus.hephaestusSmithing.required_tier").m_130946_(": " + requiredTier));
        });
    }
}

