/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.data.particle;

import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stal111.forbidden_arcanus.core.init.ModParticles;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.valhelsia.valhelsia_core.api.common.registry.RegistryManager;
import net.valhelsia.valhelsia_core.api.datagen.DataProviderContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ParticleDataProvider
implements DataProvider {
    private final PackOutput.PathProvider particlePathProvider;
    private final RegistryManager registryManager;
    private final Map<ResourceLocation, ParticleDefinition> builders = new HashMap<ResourceLocation, ParticleDefinition>();

    public ParticleDataProvider(DataProviderContext context) {
        this.particlePathProvider = context.output().m_245269_(PackOutput.Target.RESOURCE_PACK, "particles");
        this.registryManager = context.registryManager();
    }

    protected void registerParticles() {
        this.register((ParticleType)ModParticles.SOUL.get(), this.modLoc("soul_0"), this.modLoc("soul_1"), this.modLoc("soul_2"), this.modLoc("soul_3"), this.modLoc("soul_4"), this.modLoc("soul_5"), this.modLoc("soul_6"), this.modLoc("soul_7"), this.modLoc("soul_8"), this.modLoc("soul_9"), this.modLoc("soul_10"), this.modLoc("soul_11"), this.modLoc("soul_12"), this.modLoc("soul_13"), this.modLoc("soul_14"), this.modLoc("soul_15"));
        this.register((ParticleType)ModParticles.AUREAL_MOTE.get(), this.modLoc("aureal_mote"));
        this.register((ParticleType)ModParticles.MAGIC_EXPLOSION.get(), this.modLoc("magic_explosion_0"), this.modLoc("magic_explosion_1"), this.modLoc("magic_explosion_2"), this.modLoc("magic_explosion_3"), this.modLoc("magic_explosion_4"));
        this.register((ParticleType)ModParticles.HUGE_MAGIC_EXPLOSION.get());
        this.register((ParticleType)ModParticles.MAGNETIC_GLOW.get(), this.modLoc("magnetic_glow"));
    }

    private void register(ParticleType<?> particleType, ResourceLocation ... textures) {
        this.builders.put(ForgeRegistries.PARTICLE_TYPES.getKey(particleType), new ParticleDefinition(List.of(textures)));
    }

    private void register(ParticleType<?> particleType) {
        this.builders.put(ForgeRegistries.PARTICLE_TYPES.getKey(particleType), new ParticleDefinition(null));
    }

    @NotNull
    public CompletableFuture<?> m_213708_(@NotNull CachedOutput output) {
        this.registerParticles();
        return CompletableFuture.allOf((CompletableFuture[])this.builders.entrySet().stream().map(entry -> {
            JsonElement element = (JsonElement)ParticleDefinition.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)((ParticleDefinition)entry.getValue())).getOrThrow(false, arg_0 -> ((Logger)f_252483_).error(arg_0));
            return DataProvider.m_253162_((CachedOutput)output, (JsonElement)element, (Path)this.particlePathProvider.m_245731_((ResourceLocation)entry.getKey()));
        }).toArray(CompletableFuture[]::new));
    }

    private ResourceLocation modLoc(String path) {
        return new ResourceLocation(this.getModId(), path);
    }

    @NotNull
    public String m_6055_() {
        return "forbidden_arcanus - Particles";
    }

    public String getModId() {
        return this.registryManager.modId();
    }

    public record ParticleDefinition(@Nullable List<ResourceLocation> textures) {
        public static final Codec<ParticleDefinition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.listOf().optionalFieldOf("textures").forGetter(particleDefinition -> Optional.ofNullable(particleDefinition.textures))).apply((Applicative)instance, resourceLocations -> new ParticleDefinition(resourceLocations.orElse(null))));
    }
}

