/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.api.datagen;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.valhelsia.valhelsia_core.api.common.registry.RegistryManager;

public abstract class ValhelsiaBlockLootTables
extends BlockLootSubProvider {
    public static final LootItemCondition.Builder HAS_SILK_TOUCH = MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1))));
    public static final LootItemCondition.Builder HAS_NO_SILK_TOUCH = HAS_SILK_TOUCH.m_81807_();
    public static final LootItemCondition.Builder HAS_SHEARS = MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{Items.f_42574_}));
    public static final LootItemCondition.Builder HAS_SHEARS_OR_SILK_TOUCH = HAS_SHEARS.m_285888_(HAS_SILK_TOUCH);
    public static final LootItemCondition.Builder HAS_NO_SHEARS_OR_SILK_TOUCH = HAS_SHEARS_OR_SILK_TOUCH.m_81807_();
    public static final float[] NORMAL_LEAVES_SAPLING_CHANCES = new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f};
    public static final float[] JUNGLE_LEAVES_SAPLING_CHANGES = new float[]{0.025f, 0.027777778f, 0.03125f, 0.041666668f, 0.1f};
    private final RegistryManager registryManager;

    public ValhelsiaBlockLootTables(Set<Item> explosionResistant, FeatureFlagSet flagSet, RegistryManager registryManager) {
        super(explosionResistant, flagSet);
        this.registryManager = registryManager;
    }

    public static Set<Item> immuneToExplosion() {
        return new HashSet<Item>();
    }

    protected static <T extends FunctionUserBuilder<T>> T withExplosionDecay(ItemLike item, FunctionUserBuilder<T> function) {
        return (T)(!ValhelsiaBlockLootTables.immuneToExplosion().contains(item.m_5456_()) ? function.m_79078_((LootItemFunction.Builder)ApplyExplosionDecay.m_80037_()) : function.m_79073_());
    }

    protected static <T extends ConditionUserBuilder<T>> T withSurvivesExplosion(ItemLike item, ConditionUserBuilder<T> condition) {
        return (T)(!ValhelsiaBlockLootTables.immuneToExplosion().contains(item.m_5456_()) ? condition.m_79080_(ExplosionCondition.m_81661_()) : condition.m_79073_());
    }

    protected static LootTable.Builder dropping(ItemLike item) {
        return LootTable.m_79147_().m_79161_((LootPool.Builder)ValhelsiaBlockLootTables.withSurvivesExplosion(item, LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)item))));
    }

    protected static <T extends Comparable<T> & StringRepresentable> LootTable.Builder droppingWhen(Block block, Property<T> property, T value) {
        return LootTable.m_79147_().m_79161_((LootPool.Builder)ValhelsiaBlockLootTables.withSurvivesExplosion((ItemLike)block, LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)block).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_(property, value))))));
    }

    protected static LootTable.Builder droppingAndFlowerPot(ItemLike flower) {
        return LootTable.m_79147_().m_79161_((LootPool.Builder)ValhelsiaBlockLootTables.withSurvivesExplosion((ItemLike)Blocks.f_50276_, LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Blocks.f_50276_)))).m_79161_((LootPool.Builder)ValhelsiaBlockLootTables.withSurvivesExplosion(flower, LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)flower))));
    }

    protected static LootTable.Builder droppingWithFunction(Block block, Function<LootPoolSingletonContainer.Builder<?>, LootPoolSingletonContainer.Builder<?>> mapping) {
        return LootTable.m_79147_().m_79161_((LootPool.Builder)ValhelsiaBlockLootTables.withSurvivesExplosion((ItemLike)block, LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)mapping.apply(LootItem.m_79579_((ItemLike)block)))));
    }

    protected static LootTable.Builder droppingSlab(Block slab) {
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)ValhelsiaBlockLootTables.withExplosionDecay((ItemLike)slab, LootItem.m_79579_((ItemLike)slab).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)2.0f)).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)slab).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)SlabBlock.f_56353_, (Comparable)SlabType.DOUBLE)))))));
    }

    protected static LootTable.Builder registerDoor(Block door) {
        return ValhelsiaBlockLootTables.droppingWhen(door, DoorBlock.f_52730_, DoubleBlockHalf.LOWER);
    }

    protected static LootTable.Builder dropping(Block block, LootItemCondition.Builder conditionBuilder, LootPoolEntryContainer.Builder<?> lootEntryBuilder) {
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)block).m_79080_(conditionBuilder)).m_7170_(lootEntryBuilder)));
    }

    protected void registerFlowerPot(Block flowerPot) {
        this.m_246481_(flowerPot, pot -> ValhelsiaBlockLootTables.droppingAndFlowerPot((ItemLike)((FlowerPotBlock)pot).m_53560_()));
    }

    protected void registerDropping(Block blockIn, ItemLike drop) {
        this.m_247577_(blockIn, ValhelsiaBlockLootTables.dropping(drop));
    }

    protected void registerDropSelfLootTable(Block block) {
        this.registerDropping(block, (ItemLike)block);
    }

    protected void m_246481_(Block blockIn, Function<Block, LootTable.Builder> factory) {
        this.m_247577_(blockIn, factory.apply(blockIn));
    }

    public LootPoolEntryContainer.Builder<?> setCountFromIntegerProperty(Block block, LootPoolSingletonContainer.Builder<?> lootEntryBuilder, IntegerProperty intProperty) {
        intProperty.m_6908_().forEach(integer -> lootEntryBuilder.m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)integer.intValue())).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)intProperty, integer.intValue())))));
        return lootEntryBuilder;
    }
}

