/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.integration;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.stal111.forbidden_arcanus.common.block.entity.clibano.ClibanoFireType;
import com.stal111.forbidden_arcanus.common.integration.ForbiddenArcanusJEIPlugin;
import com.stal111.forbidden_arcanus.common.recipe.ClibanoRecipe;
import com.stal111.forbidden_arcanus.core.init.ModBlocks;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class ClibanoCombustionCategory
implements IRecipeCategory<ClibanoRecipe> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("forbidden_arcanus", "textures/gui/container/clibano_combustion_jei.png");
    private final IDrawable background;
    private final IDrawable icon;
    protected final IDrawableStatic staticFlame;
    protected final IDrawableStatic staticBlueFlame;
    protected final IDrawableStatic staticPurpleFlame;
    private final HashMap<ClibanoFireType, IDrawableAnimated> animatedFlames = new HashMap();
    private final LoadingCache<Integer, IDrawableAnimated> cachedArrows;

    public ClibanoCombustionCategory(final IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(TEXTURE, 0, 0, 147, 97);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.CLIBANO_CORE.get()));
        this.staticFlame = guiHelper.createDrawable(TEXTURE, 151, 1, 12, 15);
        this.animatedFlames.put(ClibanoFireType.FIRE, guiHelper.createAnimatedDrawable(this.staticFlame, 300, IDrawableAnimated.StartDirection.TOP, true));
        this.staticBlueFlame = guiHelper.createDrawable(TEXTURE, 170, 1, 12, 15);
        this.animatedFlames.put(ClibanoFireType.SOUL_FIRE, guiHelper.createAnimatedDrawable(this.staticBlueFlame, 300, IDrawableAnimated.StartDirection.TOP, true));
        this.staticPurpleFlame = guiHelper.createDrawable(TEXTURE, 189, 1, 12, 15);
        this.animatedFlames.put(ClibanoFireType.ENCHANTED_FIRE, guiHelper.createAnimatedDrawable(this.staticBlueFlame, 300, IDrawableAnimated.StartDirection.TOP, true));
        this.cachedArrows = CacheBuilder.newBuilder().maximumSize(25L).build((CacheLoader)new CacheLoader<Integer, IDrawableAnimated>(){

            @Nonnull
            public IDrawableAnimated load(@Nonnull Integer cookTime) {
                return guiHelper.drawableBuilder(TEXTURE, 148, 32, 13, 12).buildAnimated(cookTime.intValue(), IDrawableAnimated.StartDirection.LEFT, false);
            }
        });
    }

    @Nonnull
    public RecipeType<ClibanoRecipe> getRecipeType() {
        return ForbiddenArcanusJEIPlugin.CLIBANO_COMBUSTION;
    }

    @Nonnull
    public Component getTitle() {
        return Component.m_237115_((String)"jei.forbidden_arcanus.category.clibanoCombustion");
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(@Nonnull IRecipeLayoutBuilder builder, @Nonnull ClibanoRecipe recipe, @Nonnull IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 55, 24).addIngredients((Ingredient)recipe.m_7527_().get(0));
        TagKey<Item> tagKey = recipe.getRequiredFireType().getTagKey();
        if (tagKey != null) {
            builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 12, 60).addIngredients(Ingredient.m_204132_(tagKey));
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 97, 35).addItemStack(recipe.m_8043_(Minecraft.m_91087_().f_91073_.m_9598_()));
    }

    private IDrawableAnimated getArrow(ClibanoRecipe recipe) {
        int cookTime = recipe.m_43753_();
        if (cookTime <= 0) {
            cookTime = 100;
        }
        return (IDrawableAnimated)this.cachedArrows.getUnchecked((Object)cookTime);
    }

    public void draw(@Nonnull ClibanoRecipe recipe, @Nonnull IRecipeSlotsView recipeSlotsView, @Nonnull GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.animatedFlames.get((Object)recipe.getRequiredFireType()).draw(guiGraphics, 48, 43);
        IDrawableAnimated arrow = this.getArrow(recipe);
        arrow.draw(guiGraphics, 74, 43);
        this.drawExperience(recipe, guiGraphics, 12);
        this.drawCookTime(recipe, guiGraphics, 79);
    }

    protected void drawExperience(ClibanoRecipe recipe, GuiGraphics guiGraphics, int y) {
        float experience = recipe.m_43750_();
        if (experience > 0.0f) {
            MutableComponent experienceString = Component.m_237110_((String)"gui.jei.category.smelting.experience", (Object[])new Object[]{Float.valueOf(experience)});
            Minecraft minecraft = Minecraft.m_91087_();
            Font font = minecraft.f_91062_;
            int stringWidth = font.m_92852_((FormattedText)experienceString);
            guiGraphics.m_280430_(font, (Component)experienceString, this.background.getWidth() - stringWidth, y, -8355712);
        }
    }

    protected void drawCookTime(ClibanoRecipe recipe, GuiGraphics guiGraphics, int y) {
        int cookTime = recipe.m_43753_();
        if (cookTime > 0) {
            int cookTimeSeconds = cookTime / 20;
            MutableComponent timeString = Component.m_237110_((String)"gui.jei.category.smelting.time.seconds", (Object[])new Object[]{cookTimeSeconds});
            Minecraft minecraft = Minecraft.m_91087_();
            Font font = minecraft.f_91062_;
            int stringWidth = font.m_92852_((FormattedText)timeString);
            guiGraphics.m_280430_(font, (Component)timeString, this.background.getWidth() - stringWidth, y, -8355712);
        }
    }

    @Nonnull
    public List<Component> getTooltipStrings(@Nonnull ClibanoRecipe recipe, @Nonnull IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (mouseX >= 92.0 && mouseY >= 59.0 && mouseX <= 117.0 && mouseY <= 65.0) {
            ClibanoRecipe.ResidueInfo residueInfo = recipe.getResidueInfo();
            if (residueInfo == ClibanoRecipe.ResidueInfo.NONE) {
                return List.of();
            }
            return List.of(residueInfo.getType().getComponent().m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"jei.forbidden_arcanus.clibanoCombustion.residue")).m_130946_(" (" + residueInfo.chance() * 100.0 + "%)"));
        }
        return super.getTooltipStrings((Object)recipe, recipeSlotsView, mouseX, mouseY);
    }
}

