/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.block;

import com.stal111.forbidden_arcanus.common.block.CarvedEdelwoodLogBlock;
import com.stal111.forbidden_arcanus.common.block.properties.ModBlockStateProperties;
import com.stal111.forbidden_arcanus.core.init.ModBlocks;
import com.stal111.forbidden_arcanus.core.init.ModItems;
import com.stal111.forbidden_arcanus.util.ModTags;
import java.util.EnumMap;
import javax.annotation.Nonnull;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ToolActions;
import net.valhelsia.valhelsia_core.api.common.helper.VoxelShapeHelper;
import net.valhelsia.valhelsia_core.api.common.util.ItemStackUtils;

public class EdelwoodLogBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61365_;
    public static final BooleanProperty OILY = ModBlockStateProperties.OILY;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final EnumMap<Direction.Axis, VoxelShape> SHAPES = VoxelShapeHelper.rotateAxis((VoxelShape)Shapes.m_83113_((VoxelShape)Shapes.m_83144_(), (VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), (BooleanOp)BooleanOp.f_82685_));
    private static final float RAIN_FILL_CHANCE = 0.15f;
    private static final float OILY_CHANCE = 0.025f;

    public EdelwoodLogBlock(BlockBehaviour.Properties properties) {
        super(properties);
        if (this.m_49965_().m_61092_().contains(AXIS)) {
            this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_(AXIS, (Comparable)Direction.Axis.Y)).m_61124_((Property)OILY, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        }
    }

    @Nonnull
    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return context.m_7142_(((EdelwoodLogBlock)((Object)ModBlocks.EDELWOOD_LOG.get())).m_5456_()) || context.m_7142_(((CarvedEdelwoodLogBlock)((Object)ModBlocks.CARVED_EDELWOOD_LOG.get())).m_5456_()) ? Shapes.m_83144_() : SHAPES.get(state.m_61143_(AXIS));
    }

    public BlockState m_5573_(@Nonnull BlockPlaceContext context) {
        boolean flag = context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)this.m_49966_().m_61124_(AXIS, (Comparable)context.m_43719_().m_122434_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    @Nonnull
    public BlockState m_7417_(@Nonnull BlockState state, @Nonnull Direction direction, @Nonnull BlockState neighborState, @Nonnull LevelAccessor level, @Nonnull BlockPos currentPos, @Nonnull BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return state;
    }

    public void m_213898_(@Nonnull BlockState state, @Nonnull ServerLevel level, @Nonnull BlockPos pos, @Nonnull RandomSource random) {
        if (random.m_188500_() < (double)0.025f && level.isAreaLoaded(pos, 4)) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)OILY, (Comparable)Boolean.valueOf(true)), 2);
        }
        super.m_213898_(state, level, pos, random);
    }

    public boolean m_6724_(@Nonnull BlockState state) {
        return (Boolean)state.m_61143_((Property)OILY) == false;
    }

    @Nonnull
    public InteractionResult m_6227_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_150930_(Items.f_42590_) && ((Boolean)state.m_61143_((Property)OILY)).booleanValue()) {
            ItemStack oil = new ItemStack((ItemLike)ModItems.EDELWOOD_OIL.get());
            ItemStackUtils.shrinkStack((Player)player, (ItemStack)stack);
            level.m_6263_(player, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11770_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_142346_((Entity)player, GameEvent.f_157816_, pos);
            if (stack.m_41619_()) {
                player.m_21008_(hand, oil);
            } else if (!player.m_150109_().m_36054_(oil)) {
                player.m_36176_(oil, false);
            }
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)OILY, (Comparable)Boolean.valueOf(false)));
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        if (stack.canPerformAction(ToolActions.AXE_STRIP) && !this.isCarved() && state.m_61143_(AXIS) == Direction.Axis.Y) {
            Direction direction = hit.m_82434_().m_122434_() == Direction.Axis.Y ? player.m_6350_().m_122424_() : hit.m_82434_();
            stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
            if (!level.m_5776_()) {
                CriteriaTriggers.f_10562_.m_285767_((ServerPlayer)player, pos, stack);
            }
            level.m_6263_(player, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11688_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_46597_(pos, (BlockState)((BlockState)((BlockState)((CarvedEdelwoodLogBlock)((Object)ModBlocks.CARVED_EDELWOOD_LOG.get())).m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)direction)).m_61124_((Property)OILY, (Comparable)((Boolean)state.m_61143_((Property)OILY)))).m_61124_((Property)WATERLOGGED, (Comparable)((Boolean)state.m_61143_((Property)WATERLOGGED))));
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    protected boolean shouldHandlePrecipitation(BlockState state, Level level, Biome.Precipitation precipitation) {
        if (!(((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue() || state.m_61138_(AXIS) && state.m_61143_(AXIS) != Direction.Axis.Y || precipitation != Biome.Precipitation.RAIN)) {
            return level.m_213780_().m_188501_() < 0.15f;
        }
        return false;
    }

    public void m_141997_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Biome.Precipitation precipitation) {
        if (this.shouldHandlePrecipitation(state, level, precipitation)) {
            int i = 0;
            BlockState belowState = level.m_8055_(pos.m_6625_(i + 1));
            while (!(!belowState.m_204336_(ModTags.Blocks.EDELWOOD_LOGS) || belowState.m_61138_(AXIS) && belowState.m_61143_(AXIS) != Direction.Axis.Y || ((Boolean)belowState.m_61143_((Property)WATERLOGGED)).booleanValue())) {
                belowState = level.m_8055_(pos.m_6625_(++i + 1));
            }
            level.m_46597_(pos.m_6625_(i), (BlockState)level.m_8055_(pos.m_6625_(i)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true)));
            level.m_142346_(null, GameEvent.f_157769_, pos.m_6625_(i));
        }
    }

    @Nonnull
    public BlockState m_6843_(BlockState state, @Nonnull Rotation rotation) {
        return switch (rotation) {
            case Rotation.COUNTERCLOCKWISE_90, Rotation.CLOCKWISE_90 -> {
                switch ((Direction.Axis)state.m_61143_(AXIS)) {
                    case X: {
                        yield (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.Z);
                    }
                    case Z: {
                        yield (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.X);
                    }
                }
                yield state;
            }
            default -> state;
        };
    }

    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AXIS, OILY, WATERLOGGED});
    }

    protected boolean isCarved() {
        return false;
    }

    public boolean m_7357_(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull PathComputationType type) {
        return false;
    }

    @Nonnull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }
}

