/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.client.cosmetics;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.valhelsia.valhelsia_core.client.cosmetics.CosmeticsRegistry;
import net.valhelsia.valhelsia_core.client.cosmetics.source.CosmeticsSource;
import net.valhelsia.valhelsia_core.core.ValhelsiaCore;

public record CosmeticKey(CosmeticsSource source, String name) {
    private static final String TAG_SOURCE = "Source";
    private static final String TAG_COSMETIC = "Cosmetic";

    public static Optional<CosmeticKey> of(String key) {
        String[] parts = key.split(":");
        if (parts.length != 2) {
            ValhelsiaCore.LOGGER.error("Error trying to create a cosmetic key. String cannot be parsed: " + key);
            return Optional.empty();
        }
        Optional<CosmeticsSource> optional = CosmeticsRegistry.getSource(parts[0]);
        if (optional.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new CosmeticKey(optional.get(), parts[1]));
    }

    @Nullable
    static CosmeticKey of(CompoundTag tag) {
        Optional<CosmeticsSource> optional = CosmeticsRegistry.getSource(tag.m_128461_(TAG_SOURCE));
        if (optional.isEmpty()) {
            return null;
        }
        return new CosmeticKey(optional.get(), tag.m_128461_(TAG_COSMETIC));
    }

    public CompoundTag writeToTag(CompoundTag tag) {
        tag.m_128359_(TAG_SOURCE, this.source.getName());
        tag.m_128359_(TAG_COSMETIC, this.name);
        return tag;
    }

    @Override
    public String toString() {
        return this.source.getName() + ":" + this.name;
    }
}

