/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.core.registry.helper.block;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.registries.RegistryObject;
import net.valhelsia.valhelsia_core.common.block.StrippableRotatedPillarBlock;
import net.valhelsia.valhelsia_core.common.block.ValhelsiaStandingSignBlock;
import net.valhelsia.valhelsia_core.common.block.ValhelsiaWallSignBlock;
import net.valhelsia.valhelsia_core.core.registry.RegistryClass;
import net.valhelsia.valhelsia_core.core.registry.helper.RegistryHelper;
import net.valhelsia.valhelsia_core.core.registry.helper.block.CompostableHelper;
import net.valhelsia.valhelsia_core.core.registry.helper.block.FlammableHelper;

public class BlockRegistryHelper
extends RegistryHelper<Block> {
    public final List<RegistryObject<? extends SignBlock>> signBlocks = new ArrayList<RegistryObject<? extends SignBlock>>();
    private final CreativeModeTab defaultCreativeTab;
    private final FlammableHelper flammableHelper = new FlammableHelper();
    private final CompostableHelper compostableHelper = new CompostableHelper();

    @SafeVarargs
    public BlockRegistryHelper(CreativeModeTab defaultCreativeTab, Supplier<RegistryClass> ... registryClasses) {
        super(registryClasses);
        this.defaultCreativeTab = defaultCreativeTab;
    }

    public CreativeModeTab getDefaultCreativeTab() {
        return this.defaultCreativeTab;
    }

    public RegistryHelper<Item> getItemRegistryHelper() {
        return this.getRegistryManager().getItemHelper();
    }

    public FlammableHelper getFlammableHelper() {
        return this.flammableHelper;
    }

    public CompostableHelper getCompostableHelper() {
        return this.compostableHelper;
    }

    @Override
    public <T extends Block> RegistryObject<T> register(String name, Supplier<T> block) {
        return this.register(name, block, true, this.getDefaultCreativeTab());
    }

    public <T extends Block> RegistryObject<T> register(String name, Supplier<T> block, CreativeModeTab itemGroup) {
        return this.register(name, block, true, itemGroup);
    }

    public <T extends Block> RegistryObject<T> registerNoItem(String name, Supplier<T> block) {
        return this.register(name, block, false, this.getDefaultCreativeTab());
    }

    public <T extends Block> RegistryObject<T> register(String name, Supplier<T> block, boolean item) {
        return this.register(name, block, item, this.getDefaultCreativeTab());
    }

    public <T extends Block> RegistryObject<T> register(String name, Supplier<T> block, boolean item, CreativeModeTab creativeModeTab) {
        if (item) {
            return this.register(name, block, (RegistryObject<T> t) -> new BlockItem((Block)t.get(), new Item.Properties().m_41491_(creativeModeTab)));
        }
        return this.registerInternal(name, block);
    }

    public <T extends Block> RegistryObject<T> register(String name, Supplier<T> block, Function<RegistryObject<T>, BlockItem> blockItemFunction) {
        RegistryObject registryObject = this.registerInternal(name, block);
        this.getItemRegistryHelper().registerInternal(name, () -> (BlockItem)blockItemFunction.apply(registryObject));
        return registryObject;
    }

    public RegistryObject<RotatedPillarBlock> registerLogBlock(String name, Supplier<RotatedPillarBlock> strippedBlock, MaterialColor topColor, MaterialColor barkColor) {
        return this.register(name, () -> new StrippableRotatedPillarBlock(strippedBlock, BlockBehaviour.Properties.m_60947_((Material)Material.f_76320_, state -> state.m_61143_((Property)RotatedPillarBlock.f_55923_) == Direction.Axis.Y ? topColor : barkColor).m_60978_(2.0f).m_60918_(SoundType.f_56736_)));
    }

    public RegistryObject<RotatedPillarBlock> registerStrippedLogBlock(String name, MaterialColor topColor, MaterialColor barkColor) {
        return this.register(name, () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_60947_((Material)Material.f_76320_, state -> state.m_61143_((Property)RotatedPillarBlock.f_55923_) == Direction.Axis.Y ? topColor : barkColor).m_60978_(2.0f).m_60918_(SoundType.f_56736_)));
    }

    public Pair<RegistryObject<ValhelsiaStandingSignBlock>, RegistryObject<ValhelsiaWallSignBlock>> createSignBlock(String name, MaterialColor color, WoodType woodType) {
        RegistryObject<ValhelsiaStandingSignBlock> standing = this.registerInternal(name + "_sign", () -> new ValhelsiaStandingSignBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60910_().m_60978_(1.0f).m_60918_(SoundType.f_56736_), woodType));
        RegistryObject<ValhelsiaWallSignBlock> wall = this.registerInternal(name + "_wall_sign", () -> new ValhelsiaWallSignBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)color).m_60910_().m_60978_(1.0f).m_60918_(SoundType.f_56736_).lootFrom((Supplier)standing), woodType));
        this.signBlocks.add(standing);
        this.signBlocks.add(wall);
        this.getItemRegistryHelper().register(name + "_sign", () -> new SignItem(new Item.Properties().m_41487_(16).m_41491_(this.getDefaultCreativeTab()), (Block)standing.get(), (Block)wall.get()));
        return Pair.of(standing, wall);
    }
}

