/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.block.entity.forge;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import com.stal111.forbidden_arcanus.client.FARenderTypes;
import com.stal111.forbidden_arcanus.client.model.MagicCircleModel;
import com.stal111.forbidden_arcanus.common.block.entity.forge.ritual.Ritual;
import com.stal111.forbidden_arcanus.common.block.entity.forge.ritual.RitualManager;
import com.stal111.forbidden_arcanus.core.init.ModParticles;
import java.util.Objects;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;

public class MagicCircle {
    private final RitualManager ritualManager;
    private int rotation;

    public MagicCircle(RitualManager ritualManager) {
        this.ritualManager = ritualManager;
    }

    public void tick() {
        if (this.ritualManager.isRitualActive()) {
            ++this.rotation;
        } else if (this.rotation != 0) {
            this.rotation = 0;
        }
    }

    public void setRotation(int rotation) {
        this.rotation = rotation;
    }

    public void render(PoseStack poseStack, float partialTicks, MultiBufferSource buffer, int packedLight, MagicCircleModel model) {
        if (this.ritualManager.isRitualActive()) {
            Ritual ritual = this.ritualManager.getActiveRitual();
            poseStack.m_85836_();
            float ticks = (float)this.rotation + partialTicks;
            poseStack.m_85837_(0.5, 0.0, 0.5);
            float size = 1.0f + Math.min(ticks, 100.0f) / 100.0f * 7.5f;
            poseStack.m_85841_(size, 1.0f, size);
            float alpha = ticks > (float)ritual.getTime() * 0.9f ? Math.max((float)ritual.getTime() - ticks, 0.0f) / ((float)ritual.getTime() * 0.1f) : 1.0f;
            poseStack.m_85845_(Vector3f.f_122224_.m_122240_(ticks));
            model.getOuterRing().m_104306_(poseStack, buffer.m_6299_(FARenderTypes.entityFullbrightTranslucent(ritual.getOuterTexture())), packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, alpha);
            poseStack.m_85845_(Vector3f.f_122224_.m_122240_(-ticks * 2.0f));
            model.getInnerRing().m_104306_(poseStack, buffer.m_6299_(FARenderTypes.entityFullbrightTranslucent(ritual.getInnerTexture())), packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, alpha);
            poseStack.m_85849_();
            if (ticks > (float)ritual.getTime() * 0.9f) {
                Level level = Objects.requireNonNull(this.ritualManager.getBlockEntity().m_58904_());
                BlockPos pos = this.ritualManager.getBlockEntity().m_58899_();
                RandomSource random = level.m_213780_();
                double posX = (double)pos.m_123341_() + 0.25 + (double)random.m_188501_() + (double)random.m_188503_(4);
                double posZ = (double)pos.m_123343_() + 0.25 + (double)random.m_188501_() + (double)random.m_188503_(4);
                double ySpeed = ((double)random.m_188501_() - 0.4) * 0.125;
                level.m_7106_((ParticleOptions)ModParticles.AUREAL_MOTE.get(), posX - 2.0, (double)((float)pos.m_123342_() + 0.1f), posZ - 2.0, 0.0, ySpeed, 0.0);
            }
        }
    }
}

