/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.block.entity.forge.ritual;

import com.stal111.forbidden_arcanus.common.block.entity.forge.HephaestusForgeBlockEntity;
import com.stal111.forbidden_arcanus.common.block.entity.forge.ritual.EssenceManager;
import net.minecraft.network.FriendlyByteBuf;

public record RitualEssences(int aureal, int corruption, int souls, int blood, int experience) {
    public boolean checkEssences(HephaestusForgeBlockEntity tileEntity) {
        EssenceManager manager = tileEntity.getEssenceManager();
        if (manager.getAureal() < this.aureal()) {
            return false;
        }
        if (manager.getCorruption() < this.corruption()) {
            return false;
        }
        if (manager.getSouls() < this.souls()) {
            return false;
        }
        if (manager.getBlood() < this.blood()) {
            return false;
        }
        return manager.getExperience() >= this.experience();
    }

    public void reduceEssences(HephaestusForgeBlockEntity blockEntity) {
        EssenceManager manager = blockEntity.getEssenceManager();
        manager.decreaseAureal(this.aureal());
        manager.decreaseCorruption(this.corruption());
        manager.decreaseSouls(this.souls());
        manager.decreaseBlood(this.blood());
        manager.decreaseExperience(this.experience());
    }

    public int getFromName(String name) {
        return switch (name) {
            case "Aureal" -> this.aureal();
            case "Corruption" -> this.corruption();
            case "Souls" -> this.souls();
            case "Blood" -> this.blood();
            case "Experience" -> this.experience();
            default -> 0;
        };
    }

    public void serializeToNetwork(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.aureal());
        buffer.m_130130_(this.corruption());
        buffer.m_130130_(this.souls());
        buffer.m_130130_(this.blood());
        buffer.m_130130_(this.experience());
    }

    public static RitualEssences fromNetwork(FriendlyByteBuf buffer) {
        return new RitualEssences(buffer.m_130242_(), buffer.m_130242_(), buffer.m_130242_(), buffer.m_130242_(), buffer.m_130242_());
    }
}

