/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.item;

import com.stal111.forbidden_arcanus.common.entity.CustomBoat;
import com.stal111.forbidden_arcanus.common.entity.ModBoat;
import com.stal111.forbidden_arcanus.common.entity.ModChestBoat;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.BoatItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.valhelsia.valhelsia_core.common.util.ItemStackUtils;

public class ModBoatItem
extends BoatItem {
    private static final Predicate<Entity> ENTITY_PREDICATE = EntitySelector.f_20408_.and(Entity::m_6087_);
    private final ModBoat.Type woodType;
    private final boolean hasChest;

    public ModBoatItem(boolean hasChest, ModBoat.Type woodType, Item.Properties properties) {
        super(hasChest, Boat.Type.OAK, properties);
        this.woodType = woodType;
        this.hasChest = hasChest;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level level, Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        BlockHitResult hitResult = ModBoatItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (hitResult.m_6662_() != HitResult.Type.MISS) {
            Vec3 vec3 = player.m_20252_(1.0f);
            List list = level.m_6249_((Entity)player, player.m_20191_().m_82369_(vec3.m_82490_(5.0)).m_82400_(1.0), ENTITY_PREDICATE);
            if (!list.isEmpty()) {
                Vec3 vec31 = player.m_146892_();
                for (Entity entity : list) {
                    if (!entity.m_20191_().m_82400_((double)entity.m_6143_()).m_82390_(vec31)) continue;
                    return InteractionResultHolder.m_19098_((Object)stack);
                }
            }
            if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
                CustomBoat customBoat = this.getBoat(level, (HitResult)hitResult);
                customBoat.setWoodType(this.woodType);
                if (!(customBoat instanceof Boat)) {
                    return InteractionResultHolder.m_19098_((Object)stack);
                }
                Boat boat = (Boat)customBoat;
                boat.m_146922_(player.m_146908_());
                if (!level.m_45756_((Entity)boat, boat.m_20191_())) {
                    return InteractionResultHolder.m_19100_((Object)stack);
                }
                if (!level.m_5776_()) {
                    level.m_7967_((Entity)boat);
                    level.m_220400_((Entity)player, GameEvent.f_157810_, hitResult.m_82450_());
                    ItemStackUtils.shrinkStack((Player)player, (ItemStack)stack);
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.m_5776_());
            }
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    private CustomBoat getBoat(Level level, HitResult hitResult) {
        return this.hasChest ? new ModChestBoat(level, hitResult.m_82450_().f_82479_, hitResult.m_82450_().f_82480_, hitResult.m_82450_().f_82481_) : new ModBoat(level, hitResult.m_82450_().f_82479_, hitResult.m_82450_().f_82480_, hitResult.m_82450_().f_82481_);
    }
}

