/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import com.stal111.forbidden_arcanus.client.FARenderTypes;
import com.stal111.forbidden_arcanus.common.block.entity.BlackHoleBlockEntity;
import javax.annotation.Nonnull;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;

public class BlackHoleRenderer
implements BlockEntityRenderer<BlackHoleBlockEntity> {
    public static final ModelLayerLocation BLACK_HOLE_LAYER = new ModelLayerLocation(new ResourceLocation("forbidden_arcanus", "black_hole"), "main");
    public static final ModelLayerLocation BLACK_HOLE_AURA_LAYER = new ModelLayerLocation(new ResourceLocation("forbidden_arcanus", "black_hole"), "aura");
    private static final ResourceLocation BLACK_HOLE_TEXTURE = new ResourceLocation("forbidden_arcanus", "textures/block/black_hole.png");
    private static final ResourceLocation[] BLACK_HOLE_AURA = new ResourceLocation[]{new ResourceLocation("forbidden_arcanus", "textures/block/black_hole_aura_0.png"), new ResourceLocation("forbidden_arcanus", "textures/block/black_hole_aura_1.png"), new ResourceLocation("forbidden_arcanus", "textures/block/black_hole_aura_2.png")};
    private static final RenderType RENDER_TYPE = RenderType.m_110458_((ResourceLocation)BLACK_HOLE_TEXTURE);
    private static final RenderType[] AURA_RENDER_TYPE = new RenderType[]{FARenderTypes.entityFullbrightCutout(BLACK_HOLE_AURA[0]), FARenderTypes.entityFullbrightCutout(BLACK_HOLE_AURA[1]), FARenderTypes.entityFullbrightCutout(BLACK_HOLE_AURA[2])};
    private static final float SIN_45 = (float)Math.sin(1.0471975511965976);
    private final ModelPart hole;
    private final ModelPart aura;

    public BlackHoleRenderer(BlockEntityRendererProvider.Context context) {
        this.hole = context.m_173582_(BLACK_HOLE_LAYER);
        this.aura = context.m_173582_(BLACK_HOLE_AURA_LAYER);
    }

    public static LayerDefinition createHoleLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        meshDefinition.m_171576_().m_171599_("hole", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-3.0f, -3.0f, -3.0f, 6.0f, 6.0f, 6.0f), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)16, (int)16);
    }

    public static LayerDefinition createAuraLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        meshDefinition.m_171576_().m_171599_("aura", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-10.0f, 0.0f, -10.0f, 20.0f, 0.1f, 20.0f), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)20, (int)20);
    }

    public void render(@Nonnull BlackHoleBlockEntity blockEntity, float partialTicks, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.5, 0.5);
        VertexConsumer vertexconsumer = bufferSource.m_6299_(RENDER_TYPE);
        float rotation = ((float)blockEntity.rotation + partialTicks) * 3.0f;
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(rotation));
        poseStack.m_85836_();
        poseStack.m_85845_(new Quaternion(new Vector3f(SIN_45, 0.0f, SIN_45), 60.0f, true));
        this.hole.m_104301_(poseStack, vertexconsumer, packedLight, packedOverlay);
        poseStack.m_85849_();
        vertexconsumer = bufferSource.m_6299_(AURA_RENDER_TYPE[blockEntity.auraTexture]);
        this.aura.m_104301_(poseStack, vertexconsumer, packedLight, packedOverlay);
        poseStack.m_85849_();
    }
}

