/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.block.entity.forge.ritual;

import com.stal111.forbidden_arcanus.common.block.entity.PedestalBlockEntity;
import com.stal111.forbidden_arcanus.common.block.entity.forge.HephaestusForgeBlockEntity;
import com.stal111.forbidden_arcanus.common.block.entity.forge.ritual.Ritual;
import com.stal111.forbidden_arcanus.common.entity.CrimsonLightningBoltEntity;
import com.stal111.forbidden_arcanus.common.item.RitualStarterItem;
import com.stal111.forbidden_arcanus.common.loader.RitualLoader;
import com.stal111.forbidden_arcanus.common.network.NetworkHandler;
import com.stal111.forbidden_arcanus.common.network.clientbound.UpdateForgeRitualPacket;
import com.stal111.forbidden_arcanus.common.network.clientbound.UpdatePedestalPacket;
import com.stal111.forbidden_arcanus.core.init.ModEntities;
import com.stal111.forbidden_arcanus.core.init.ModParticles;
import com.stal111.forbidden_arcanus.core.init.other.ModPOITypes;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.valhelsia.valhelsia_core.common.util.NeedsStoring;

public class RitualManager
implements NeedsStoring {
    private final HephaestusForgeBlockEntity blockEntity;
    private final List<BlockPos> cachedPedestals = new ArrayList<BlockPos>();
    private Ritual activeRitual;
    private int counter;
    private int lightningCounter;

    public RitualManager(HephaestusForgeBlockEntity blockEntity) {
        this.blockEntity = blockEntity;
    }

    public HephaestusForgeBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public Ritual getActiveRitual() {
        return this.activeRitual;
    }

    public void setActiveRitual(Ritual ritual) {
        this.activeRitual = ritual;
    }

    public boolean isRitualActive() {
        return this.activeRitual != null;
    }

    public void tryStartRitual(ServerLevel level, ItemStack stack, Player player) {
        RitualStarterItem ritualStarterItem = (RitualStarterItem)stack.m_41720_();
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        if (ritualStarterItem.getRemainingUses(stack) <= 0) {
            return;
        }
        this.forEachPedestal(level, PedestalBlockEntity::hasStack, pedestalBlockEntity -> list.add(pedestalBlockEntity.getStack()), true);
        for (Ritual ritual : RitualLoader.getRituals()) {
            if (!ritual.canStart(list, this.blockEntity)) continue;
            if (!player.m_150110_().f_35937_) {
                ritualStarterItem.setRemainingUses(stack, ritualStarterItem.getRemainingUses(stack) - 1);
            }
            this.startRitual(ritual);
            return;
        }
    }

    public void startRitual(Ritual ritual) {
        this.setActiveRitual(ritual);
        ritual.getEssences().reduceEssences(this.blockEntity);
    }

    public void tick(ServerLevel level, BlockPos pos) {
        if (!this.isRitualActive()) {
            return;
        }
        RandomSource random = level.m_213780_();
        int time = this.getActiveRitual().getTime();
        ++this.counter;
        this.updateCachedPedestals(level);
        if (this.lightningCounter != 0) {
            ++this.lightningCounter;
            if (this.lightningCounter == 300) {
                ArrayList<ItemStack> list = new ArrayList<ItemStack>();
                this.forEachPedestal(level, PedestalBlockEntity::hasStack, pedestalBlockEntity -> list.add(pedestalBlockEntity.getStack()));
                if (!this.getActiveRitual().checkIngredients(list, this.blockEntity)) {
                    this.failRitual(level);
                    NetworkHandler.sendToTrackingChunk(level.m_46745_(pos), new UpdateForgeRitualPacket(pos, this.activeRitual));
                    return;
                }
                this.lightningCounter = 0;
            }
        }
        this.forEachPedestal(level, PedestalBlockEntity::hasStack, pedestalBlockEntity -> {
            BlockPos pedestalPos = pedestalBlockEntity.m_58899_();
            if (pedestalBlockEntity.getItemHeight() != 140) {
                int height = pedestalBlockEntity.getItemHeight() + 1;
                pedestalBlockEntity.setItemHeight(height);
                NetworkHandler.sendToTrackingChunk(level.m_46745_(pedestalPos), new UpdatePedestalPacket(pedestalPos, pedestalBlockEntity.getStack(), height));
            }
            this.addItemParticles(level, pedestalPos, pedestalBlockEntity.getItemHeight(), pedestalBlockEntity.getStack());
        });
        if ((float)this.counter == (float)time / 2.0f && random.m_188500_() <= this.getFailureChance() * 2.0) {
            CrimsonLightningBoltEntity entity = new CrimsonLightningBoltEntity((EntityType<? extends LightningBolt>)((EntityType)ModEntities.CRIMSON_LIGHTNING_BOLT.get()), (Level)level);
            entity.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5);
            entity.m_20874_(true);
            level.m_7967_((Entity)entity);
            ++this.lightningCounter;
            this.forEachPedestal(level, PedestalBlockEntity::hasStack, pedestalBlockEntity -> {
                if (random.m_188499_()) {
                    ItemStack stack = pedestalBlockEntity.getStack().m_41777_();
                    BlockPos pedestalPos = pedestalBlockEntity.m_58899_();
                    level.m_7967_((Entity)new ItemEntity((Level)level, (double)pedestalPos.m_123341_() + 0.5, (double)((float)pedestalPos.m_123342_() + (float)pedestalBlockEntity.getItemHeight() / 100.0f), (double)pedestalPos.m_123343_() + 0.5, stack));
                    pedestalBlockEntity.clearStack((Level)level);
                }
            });
        }
        if (this.counter == time) {
            if (random.m_188500_() > this.getFailureChance()) {
                this.finishRitual(level);
            } else {
                this.failRitual(level);
            }
        }
        NetworkHandler.sendToTrackingChunk(level.m_46745_(pos), new UpdateForgeRitualPacket(pos, this.activeRitual));
    }

    public void finishRitual(ServerLevel level) {
        this.blockEntity.m_6836_(4, this.getActiveRitual().getResult());
        this.reset();
        this.forEachPedestal(level, PedestalBlockEntity::hasStack, pedestalBlockEntity -> pedestalBlockEntity.clearStack((Level)level));
    }

    public void failRitual(ServerLevel level) {
        ItemStack stack = this.blockEntity.m_8020_(4);
        BlockPos pos = this.blockEntity.m_58899_();
        this.reset();
        if (!stack.m_41619_()) {
            level.m_7967_((Entity)new ItemEntity((Level)level, (double)pos.m_123341_() + 0.5, (double)(pos.m_123342_() + 1), (double)pos.m_123343_() + 0.5, stack));
            this.blockEntity.m_6836_(4, ItemStack.f_41583_);
        }
        this.forEachPedestal(level, PedestalBlockEntity::hasStack, pedestalBlockEntity -> {
            pedestalBlockEntity.clearStack((Level)level);
            this.blockEntity.getEssenceManager().increaseCorruption(2);
        });
        level.m_8767_((ParticleOptions)((SimpleParticleType)ModParticles.HUGE_MAGIC_EXPLOSION.get()), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 0, 1.0, 0.0, 0.0, 0.0);
        level.m_6263_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_11913_, SoundSource.BLOCKS, 4.0f, (1.0f + (level.m_213780_().m_188501_() - level.m_213780_().m_188501_()) * 0.2f) * 0.7f);
    }

    private void addItemParticles(ServerLevel level, BlockPos pedestalPos, int itemHeight, ItemStack stack) {
        BlockPos pos = this.blockEntity.m_58899_();
        double posX = (double)pedestalPos.m_123341_() + 0.5;
        double posY = (double)pedestalPos.m_123342_() + 0.1 + (double)((float)itemHeight / 100.0f);
        double posZ = (double)pedestalPos.m_123343_() + 0.5;
        double xSpeed = 0.1 * (double)(pos.m_123341_() - pedestalPos.m_123341_());
        double ySpeed = 0.22;
        double zSpeed = 0.1 * (double)(pos.m_123343_() - pedestalPos.m_123343_());
        if (level.m_213780_().m_188500_() < 0.6) {
            level.m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), posX, posY, posZ, 0, xSpeed, ySpeed, zSpeed, 0.9);
        }
    }

    private void reset() {
        this.counter = 0;
        this.lightningCounter = 0;
        this.setActiveRitual(null);
    }

    public double getFailureChance() {
        return (float)(this.getBlockEntity().getEssenceManager().getCorruption() + 5) / (float)this.getBlockEntity().getForgeLevel().getMaxCorruption() / 2.0f;
    }

    public CompoundTag save(CompoundTag tag) {
        if (this.isRitualActive()) {
            tag.m_128359_("ActiveRitual", this.getActiveRitual().getName().toString());
            tag.m_128405_("Counter", this.counter);
            if (this.lightningCounter != 0) {
                tag.m_128405_("LightningCounter", this.lightningCounter);
            }
        }
        return tag;
    }

    public void load(CompoundTag tag) {
        if (tag.m_128441_("ActiveRitual")) {
            this.setActiveRitual(RitualLoader.getRitual(new ResourceLocation(tag.m_128461_("ActiveRitual"))));
            this.counter = tag.m_128451_("Counter");
            if (this.counter != 0) {
                this.blockEntity.getMagicCircle().setRotation(this.counter);
            }
            if (tag.m_128441_("LightningCounter")) {
                this.lightningCounter = tag.m_128451_("LightningCounter");
            }
        }
    }

    public void updateCachedPedestals(ServerLevel level) {
        PoiManager manager = level.m_8904_();
        this.cachedPedestals.clear();
        manager.m_27181_(poiType -> poiType.get() == ModPOITypes.PEDESTAL.get(), this.blockEntity.m_58899_(), 4, PoiManager.Occupancy.ANY).forEach(pointOfInterest -> this.cachedPedestals.add(pointOfInterest.m_27257_()));
    }

    public void forEachPedestal(ServerLevel level, Predicate<PedestalBlockEntity> predicate, Consumer<PedestalBlockEntity> consumer) {
        this.forEachPedestal(level, predicate, consumer, false);
    }

    public void forEachPedestal(ServerLevel level, Predicate<PedestalBlockEntity> predicate, Consumer<PedestalBlockEntity> consumer, boolean updatePedestals) {
        if (updatePedestals) {
            this.updateCachedPedestals(level);
        }
        this.cachedPedestals.stream().map(pos -> (PedestalBlockEntity)level.m_7702_(pos)).filter(predicate).forEach(consumer);
    }
}

