/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.data.recipes.builder;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.stal111.forbidden_arcanus.common.recipe.CombineResiduesRecipe;
import com.stal111.forbidden_arcanus.core.init.ModRecipes;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public record CombineResiduesRecipeBuilder(String residueName, int residueAmount, Item result, int count) implements RecipeBuilder
{
    public static CombineResiduesRecipeBuilder of(String residueName, int residueAmount, ItemLike result) {
        return new CombineResiduesRecipeBuilder(residueName, residueAmount, result.m_5456_(), 1);
    }

    public static CombineResiduesRecipeBuilder of(String residueName, int residueAmount, ItemLike result, int count) {
        return new CombineResiduesRecipeBuilder(residueName, residueAmount, result.m_5456_(), count);
    }

    @Nonnull
    public RecipeBuilder m_126132_(@Nonnull String criterionName, @Nonnull CriterionTriggerInstance criterionTrigger) {
        return this;
    }

    @Nonnull
    public RecipeBuilder m_126145_(@Nullable String groupName) {
        return this;
    }

    @Nonnull
    public Item m_142372_() {
        return this.result;
    }

    public void m_176498_(@Nonnull Consumer<FinishedRecipe> finishedRecipeConsumer) {
        ResourceLocation recipeId = RecipeBuilder.m_176493_((ItemLike)this.m_142372_());
        this.m_126140_(finishedRecipeConsumer, new ResourceLocation("forbidden_arcanus", "combine_residues/" + this.residueName + "_residues_to_" + recipeId.m_135815_()));
    }

    public void m_126140_(@Nonnull Consumer<FinishedRecipe> finishedRecipeConsumer, @Nonnull ResourceLocation recipeId) {
        finishedRecipeConsumer.accept(new Result(recipeId, this.residueName, this.residueAmount, this.result, this.count, (RecipeSerializer<CombineResiduesRecipe>)((RecipeSerializer)ModRecipes.COMBINE_RESIDUES_SERIALIZER.get())));
    }

    private record Result(ResourceLocation recipeId, String residueName, int residueAmount, Item result, int count, RecipeSerializer<CombineResiduesRecipe> serializer) implements FinishedRecipe
    {
        public void m_7917_(@Nonnull JsonObject json) {
            json.addProperty("residue_name", this.residueName);
            json.addProperty("residue_amount", (Number)this.residueAmount);
            JsonObject result = new JsonObject();
            result.addProperty("item", Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)this.result)).toString());
            if (this.count > 1) {
                result.addProperty("count", (Number)this.count);
            }
            json.add("result", (JsonElement)result);
        }

        @Nonnull
        public ResourceLocation m_6445_() {
            return this.recipeId;
        }

        @Nonnull
        public RecipeSerializer<?> m_6637_() {
            return this.serializer;
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

