/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.util;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Scoreboard;

public class ModUtils {
    public static ResourceLocation location(String path) {
        return new ResourceLocation("forbidden_arcanus", path);
    }

    public static void addStrippable(Block block, Block strippedBlock) {
        AxeItem.f_150683_ = Maps.newHashMap((Map)AxeItem.f_150683_);
        AxeItem.f_150683_.put(block, strippedBlock);
    }

    public static PlayerTeam createTeam(Scoreboard scoreboard, String name, ChatFormatting color) {
        if (scoreboard.m_83488_().contains(name)) {
            return scoreboard.m_83489_(name);
        }
        PlayerTeam team = scoreboard.m_83492_(name);
        team.m_83353_((Component)Component.m_237113_((String)name));
        team.m_83351_(color);
        return team;
    }

    public static void removeTeam(Scoreboard scoreboard, PlayerTeam team) {
        if (scoreboard.m_83488_().contains(team.m_5758_())) {
            scoreboard.m_83475_(team);
        }
    }

    public static Collection<Recipe<?>> getRecipesByOutput(ItemStack targetOutput, Collection<RecipeSerializer<?>> recipeSerializer) {
        return Minecraft.m_91087_().f_91073_.m_7465_().m_44051_().stream().filter(r -> {
            boolean flag = false;
            for (RecipeSerializer serializer : recipeSerializer) {
                if (serializer != r.m_7707_()) continue;
                flag = true;
            }
            return !r.m_5598_() && flag && ItemStack.m_41758_((ItemStack)targetOutput, (ItemStack)r.m_8043_());
        }).collect(Collectors.toList());
    }

    public static Collection<Recipe<?>> getCraftingRecipesByOutput(@Nonnull ItemStack targetOutput) {
        return Minecraft.m_91087_().f_91073_.m_7465_().m_44051_().stream().filter(r -> !r.m_5598_() && (r.m_7707_() == RecipeSerializer.f_44076_ || r.m_7707_() == RecipeSerializer.f_44077_) && ItemStack.m_41758_((ItemStack)targetOutput, (ItemStack)r.m_8043_())).collect(Collectors.toList());
    }

    public static Collection<Recipe<?>> getSmeltingRecipesByOutput(@Nonnull ItemStack targetOutput) {
        return Minecraft.m_91087_().f_91073_.m_7465_().m_44051_().stream().filter(r -> !r.m_5598_() && r.m_7707_() == RecipeSerializer.f_44091_ && ItemStack.m_41758_((ItemStack)targetOutput, (ItemStack)r.m_8043_())).collect(Collectors.toList());
    }

    public static boolean hasBlockEnoughSolidSite(VoxelShape shape, LevelReader world, BlockPos pos, Direction direction) {
        BlockState state = world.m_8055_(pos);
        if (direction == Direction.DOWN && state.m_204336_(BlockTags.f_13056_)) {
            return false;
        }
        return !Shapes.m_83157_((VoxelShape)state.m_60816_((BlockGetter)world, pos).m_83263_(direction), (VoxelShape)shape, (BooleanOp)BooleanOp.f_82683_);
    }

    public static Vec3 blockPosToVector(BlockPos pos) {
        return ModUtils.blockPosToVector(pos, 0.0);
    }

    public static Vec3 blockPosToVector(BlockPos pos, double offset) {
        return new Vec3((double)pos.m_123341_() + offset, (double)pos.m_123342_() + offset, (double)pos.m_123343_() + offset);
    }
}

