/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.valhelsia.valhelsia_core.client.cosmetics.CosmeticKey;
import net.valhelsia.valhelsia_core.client.cosmetics.CosmeticsCategory;
import net.valhelsia.valhelsia_core.client.cosmetics.CosmeticsManager;
import net.valhelsia.valhelsia_core.client.model.CosmeticsModel;
import net.valhelsia.valhelsia_core.client.model.WitchsBroomModel;

public class CosmeticsSpecialLayer<T extends AbstractClientPlayer, M extends PlayerModel<T>>
extends RenderLayer<T, M> {
    private final CosmeticsManager cosmeticsManager;
    private CosmeticsModel<T> model = new WitchsBroomModel();

    public CosmeticsSpecialLayer(RenderLayerParent<T, M> renderLayerParent) {
        super(renderLayerParent);
        this.cosmeticsManager = CosmeticsManager.getInstance();
    }

    public void render(@Nonnull PoseStack poseStack, @Nonnull MultiBufferSource buffer, int packedLight, @Nonnull T player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        UUID uuid = player.m_20148_();
        this.cosmeticsManager.getActiveCosmetic(uuid, CosmeticsCategory.SPECIAL).ifPresent(key -> {
            List<CosmeticKey> cosmetics = this.cosmeticsManager.getCosmetics(uuid, CosmeticsCategory.SPECIAL);
            if (!cosmetics.contains(key)) {
                return;
            }
            ResourceLocation texture = this.cosmeticsManager.getMainTexture((CosmeticKey)key);
            this.model = this.cosmeticsManager.getTypeOrThrow((CosmeticKey)key).getModel();
            if (texture == null) {
                return;
            }
            poseStack.m_85836_();
            if (this.model.translateToParent()) {
                ((PlayerModel)this.m_117386_()).m_5585_().m_104299_(poseStack);
            }
            if (this.model != null) {
                VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_110452_((ResourceLocation)texture));
                this.model.getModel().m_6973_((Entity)player, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
                this.model.setPosition(poseStack);
                this.model.getModel().m_7695_(poseStack, vertexConsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
            poseStack.m_85849_();
        });
    }
}

