/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.client.util.combiner;

import java.util.List;
import net.valhelsia.valhelsia_core.client.util.combiner.BlockCombiner;

public interface BlockCombineResult<S> {
    public <T> T apply(BlockCombiner.Combiner<S, T> var1);

    public List<S> getValues();

    public static final class Multiple<S>
    implements BlockCombineResult<S> {
        private final List<S> list;

        public Multiple(List<S> values) {
            this.list = values;
        }

        @Override
        public <T> T apply(BlockCombiner.Combiner<S, T> combiner) {
            return combiner.acceptMultiple(this.list);
        }

        @Override
        public List<S> getValues() {
            return this.list;
        }
    }

    public static final class Double<S>
    implements BlockCombineResult<S> {
        private final S first;
        private final S second;

        public Double(S first, S second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public <T> T apply(BlockCombiner.Combiner<S, T> combiner) {
            return combiner.acceptDouble(this.first, this.second);
        }

        @Override
        public List<S> getValues() {
            return List.of(this.first, this.second);
        }
    }

    public static final class Single<S>
    implements BlockCombineResult<S> {
        private final S single;

        public Single(S single) {
            this.single = single;
        }

        @Override
        public <T> T apply(BlockCombiner.Combiner<S, T> combiner) {
            return combiner.acceptSingle(this.single);
        }

        @Override
        public List<S> getValues() {
            return List.of(this.single);
        }
    }
}

