/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.block.entity.forge;

public enum HephaestusForgeLevel {
    ONE("1", 0, 200, 200, 1, 5000, 200, 1),
    TWO("2", 1, 500, 500, 5, 10000, 300, 2),
    THREE("3", 2, 800, 800, 10, 30000, 400, 3),
    FOUR("4", 3, 1000, 1000, 100, 50000, 1000, 4),
    X("X", 4, 3000, 3000, 666, 100000, 2000, 4);

    private final String name;
    private final int index;
    private final int maxAureal;
    private final int maxCorruption;
    private final int maxSouls;
    private final int maxBlood;
    private final int maxExperience;
    private final int enhancerSlots;

    private HephaestusForgeLevel(String name, int index, int maxAureal, int maxCorruption, int maxSouls, int maxBlood, int maxExperience, int enhancerSlots) {
        this.name = name;
        this.index = index;
        this.maxAureal = maxAureal;
        this.maxCorruption = maxCorruption;
        this.maxSouls = maxSouls;
        this.maxBlood = maxBlood;
        this.maxExperience = maxExperience;
        this.enhancerSlots = enhancerSlots;
    }

    public String getName() {
        return this.name;
    }

    public int getIndex() {
        return this.index;
    }

    public int getMaxAureal() {
        return this.maxAureal;
    }

    public int getMaxCorruption() {
        return this.maxCorruption;
    }

    public int getMaxSouls() {
        return this.maxSouls;
    }

    public int getMaxBlood() {
        return this.maxBlood;
    }

    public int getMaxExperience() {
        return this.maxExperience;
    }

    public int getEnhancerSlots() {
        return this.enhancerSlots;
    }

    public static HephaestusForgeLevel getRequiredLevelForSlot(int slot) {
        for (HephaestusForgeLevel level : HephaestusForgeLevel.values()) {
            if (level.getEnhancerSlots() != slot) continue;
            return level;
        }
        return ONE;
    }

    public static HephaestusForgeLevel getFromName(String name) {
        return switch (name) {
            case "2" -> TWO;
            case "3" -> THREE;
            case "4" -> FOUR;
            case "x" -> X;
            default -> ONE;
        };
    }

    public static HephaestusForgeLevel getFromIndex(int index) {
        return switch (index) {
            case 1 -> TWO;
            case 2 -> THREE;
            case 3 -> FOUR;
            case 4 -> X;
            default -> ONE;
        };
    }
}

